/////////////////////////////////////////////////////////////////////////////
// UTILCLS.H - COM/ActiveX Utility Classes
//
// (This file provides various COM/ActiveX utility/helper classes that
// (a) Are used by the code generated by C++Builder Import|Typelib|ActiveX files
// (b) Can be used to easily access COM Objects
// (c) Ease COM related tasks such as Initializing OLE, VARIANT wrappers etc.
//
// 1.2
// 2002/01/02 19:50:33
//
// Copyright (c) 1998, 2002 Borland Software Corporation
/////////////////////////////////////////////////////////////////////////////
#ifndef __UTILCLS_H
#define __UTILCLS_H

///////////////////////////////////////////////////////////////////////////////
// To keep track of version of UTILITY class header
//
// This version is checked by the files generated by the TLIBIMP utility or
// via the Import|TypeLibrary and Import|ActiveXControl features of
// C++Builder.
//
// NOTE: Version 0x0101: Shipping C++Builder v4.0
//       Version 0x0102: Update to C++Builder v4.0
//       Version 0x0500: Shipping version of C++Builder v5.0
//       Version 0X0504: C++ Builder 5.0 patch 1.
//       Version 0x0600: C++ Builder v.6
//       Version 0x0700: C++ Builder 2006
///////////////////////////////////////////////////////////////////////////////

#define __UTILCLS_H_VERSION 0x0700

#include <objbase.h>
#include <oleauto.h>
#include <cguid.h>
#include <stdarg.h>
#include <tchar.h>
#include <cguid.h>
#include <olectl.h>

////////////////////////////////////////////////////////////////////////////////
// Typedefs to avoid 'simple type expected' error from compiler
////////////////////////////////////////////////////////////////////////////////

typedef signed   char    signed_char;
typedef unsigned char    unsigned_char;
typedef unsigned short   unsigned_short;
typedef unsigned long    unsigned_long;
typedef unsigned __int64 unsigned_int64;

////////////////////////////////////////////////////////////////////////////////
// Forward references
////////////////////////////////////////////////////////////////////////////////

template <class DISPINTF = IDispatch> class TAutoDriver;
template <class DISPINTF = IDispatch> class TDispId;
template <class T, bool CLEANUP> class TVariantT;
template <class T, bool CLEANUP> class TVariantInParamT;

HRESULT COMHlpr_ConnectEvents(REFIID eventsIID, IUnknown* server, IUnknown* sink, DWORD &cookie);
HRESULT COMHlpr_DisconnectEvents(REFIID eventsIID, IUnknown* server, DWORD &cookie);



////////////////////////////////////////////////////////////////////////////////
// Macros
////////////////////////////////////////////////////////////////////////////////

// C++Builder5 supports __uuidof(T)/declspec(uuid(xx)). Previous versions do not.

#if !defined(DECLSPEC_UUID)
#if (__BORLANDC__ >= 0x550)
#define DECLSPEC_UUID(guid) __declspec(uuid(guid))

// DECLSEPEC_UUID redeclarations for interfaces defined in oaidl.h
//
interface DECLSPEC_UUID("00000000-0000-0000-C000-000000000046") IUnknown;
interface DECLSPEC_UUID("00020400-0000-0000-C000-000000000046") IDispatch;
interface DECLSPEC_UUID("00020405-0000-0000-C000-000000000046") ICreateTypeInfo;
interface DECLSPEC_UUID("0002040E-0000-0000-C000-000000000046") ICreateTypeInfo2;
interface DECLSPEC_UUID("00020406-0000-0000-C000-000000000046") ICreateTypeLib;
interface DECLSPEC_UUID("0002040F-0000-0000-C000-000000000046") ICreateTypeLib2;
interface DECLSPEC_UUID("00020404-0000-0000-C000-000000000046") IEnumVARIANT;
interface DECLSPEC_UUID("00020403-0000-0000-C000-000000000046") ITypeComp;
interface DECLSPEC_UUID("00020401-0000-0000-C000-000000000046") ITypeInfo;
interface DECLSPEC_UUID("00020412-0000-0000-C000-000000000046") ITypeInfo2;
interface DECLSPEC_UUID("00020402-0000-0000-C000-000000000046") ITypeLib;
interface DECLSPEC_UUID("00020411-0000-0000-C000-000000000046") ITypeLib2;
interface DECLSPEC_UUID("00020410-0000-0000-C000-000000000046") ITypeChangeEvents;
interface DECLSPEC_UUID("1CF2B120-547D-101B-8E65-08002B2BD119") IErrorInfo;
interface DECLSPEC_UUID("22F03340-547D-101B-8E65-08002B2BD119") ICreateErrorInfo;
interface DECLSPEC_UUID("DF0B3D60-548F-101B-8E65-08002B2BD119")	ISupportErrorInfo;
interface DECLSPEC_UUID("0000002E-0000-0000-C000-000000000046")	ITypeFactory;
interface DECLSPEC_UUID("0000002D-0000-0000-C000-000000000046")	ITypeMarshal;
interface DECLSPEC_UUID("0000002F-0000-0000-C000-000000000046")	IRecordInfo;
interface DECLSPEC_UUID("3127CA40-446E-11CE-8135-00AA004BB851") IErrorLog;
interface DECLSPEC_UUID("55272A00-42CB-11CE-8135-00AA004BB851") IPropertyBag;
#else
#define DECLSPEC_UUID(guid)
#endif
#endif

// CONNECTIONPOINT_ARRAY_SIZE is used by the Fire_xxxx Event templates generated for
// outgoing interfaces in the xxxx_TLB.H file.
//
// Redefine this macro if you want your server to support more (or fewer ) sinks.

#if !defined(CONNECTIONPOINT_ARRAY_SIZE)
#define CONNECTIONPOINT_ARRAY_SIZE  5
#endif

#if !defined(OLETEXT)
#define OLETEXT(x)  L ## x
#endif

#if !defined(NO_PROMPT_ON_ASSERTE_FAILURE)
#define PROMPT_ON_ASSERTE_FAILURE 1
#endif
#if !defined(NO_PROMPT_ON_HRCHECK_FAILURE)
#define PROMPT_ON_HRCHECK_FAILURE 1
#endif



////////////////////////////////////////////////////////////////////////////////
// Helper classes and functions for debugging.
////////////////////////////////////////////////////////////////////////////////

// Implementation of TRACE_HLPR
template <class T>
class TDebugHlpr
{
public:
  static void __cdecl TRACE_HLPR(T* szFormat, ...);
};

// Helper used to throw an exception
template <class T>
void DebugHlpr_THROW(T* msg, HRESULT hr, T* file, bool /*assertFailed*/)
{
#if defined(ComobjHPP)
  // NOTE: This does not retrieve rich error information, the way Delphi and VB environments
  //       do. Eventually this 'throw' will either throw a rich EOleException or some other
  //       OLE exception class (something equivalent to _com_error, maybe??)
  //
  //       For now, you can specialized [T = TCHAR] 'DebugHlpr_THROW' to retrieve rich error
  //       information and throw a VCL exception class, if you're using VCL classes already,
  //       or throw a custom exception class.
  //
  //       NOTE: Use the assertFailed parameter to distinguish between Assertion and
  //             OLECHECK failures. (Maybe throw something different??)
  throw EOleException(msg, hr, file, _T(""), 0);
#else
  throw msg;  // Hopefully we never get here: Need something much better to throw!!
#endif
}

// Implementation of OLECHECK - Throw an exception if !SUCCEEDED(hr)
template <class T>
HRESULT DebugHlpr_HRCHECK(HRESULT hr, T* expr, T* file, int line)
{
  if (!SUCCEEDED(hr))
  {
    TCHAR szMsg[_MAX_PATH*2];
    TCHAR lfile[_MAX_PATH*2];

    if (file)
      ::wsprintf(lfile, _T("%s"), file);
    else
      ::wsprintf(lfile, _T(""));

    LPVOID msg = 0;
    if (::FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM, 0, hr,
                        MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), LPTSTR(&msg), 0, 0) && (msg != 0))
    {
      ::wsprintf(szMsg, _T("'%s': %s @ %s/%d"), expr, LPTSTR(msg), lfile, line);
      ::LocalFree(msg);
    }
    else
      ::wsprintf(szMsg, _T("(%s) Error: %lX (%ld) @ %s/%d"), expr, LONG(hr), LONG(hr), file, line);

#if !defined(PROMPT_ON_HRCHECK_FAILURE)
    int i = IDYES;
#else
    int i = DebugHlpr_PROMPT(_T("HRCHECK: "), szMsg);
#endif
    if (i == IDYES)
      DebugHlpr_THROW(szMsg, hr,lfile, false);
    else if (i == IDCANCEL)
      ::DebugBreak();
    // NOTE: IDNO - implies we keep chugging along
  }

  return hr;
}

#ifndef _INC_CRTDBG
// _ASSERTE helper return MB_YES, MB_NO or MB_CANCEL
template <class T>
int DebugHlpr_ASSERTE(T* expr, T* file, int line)
{
  TCHAR msg[_MAX_PATH*2];
  TCHAR lfile[_MAX_PATH*2];
  ::wsprintf(msg, _T("%s @ %s/%d"), LPTSTR(expr), file, line);

#if !defined(PROMPT_ON_ASSERTE_FAILURE)
  int i = IDYES;
#else
  int i = DebugHlpr_PROMPT(_T("_ASSERTE: "), msg);
#endif

  if (i == IDYES)
  {
    ::wsprintf(msg, _T("%s failed - %s/%d"), expr, file, line);
    ::wsprintf(lfile, _T("%s"), file);
    DebugHlpr_THROW(msg, E_FAIL, lfile, true);
  }
  return i;
}
#endif

// Helper used to display a MessageBox
template <class T>
int DebugHlpr_PROMPT(T* caption, T* msg)
{
  TCHAR szMsg[_MAX_PATH*2];
  wsprintf(szMsg, _T("%s\nPress [Y]es to terminate, [N]o to continue and [C]ancel to Debug"), msg);
  return ::MessageBox(0, szMsg, caption, MB_TASKMODAL|MB_ICONQUESTION|MB_YESNOCANCEL);
}


#if !defined(OLETRACE)
#define OLETRACE  TDebugHlpr<TCHAR>::TRACE_HLPR
#endif

#if !defined(OLECHECK)
#define OLECHECK(hrexpr) DebugHlpr_HRCHECK(hrexpr, #hrexpr, __FILE__, __LINE__)
#endif

#ifndef _INC_CRTDBG
#if !defined(_ASSERTE)
#define  _ASSERTE(expr) do {                                                            \
  if (!(expr) && DebugHlpr_ASSERTE(#expr, __FILE__, __LINE__) == IDCANCEL)              \
    ::DebugBreak();                                                                     \
} while (0)
#endif

// Version of _ASSERTE usable within inline functions
// i.e. Does not have do/while construct that is not allowed in inline functions currently
#if !defined(_ASSERTE_)
#define _ASSERTE_(expr)   ((expr) ? (0) : DebugHlpr_ASSERTE(#expr, __FILE__, __LINE__))
#endif
#endif

#ifdef __NOASSERTE
#define _ASSERTE(expr) expr
#define OLECHECK(hrexpr) hrexpr
#define PROMPT_ON_ASSERTE_FAILURE 0
#define PROMPT_ON_HRCHECK_FAILURE 0
#endif

template <class T>
void __cdecl TDebugHlpr<T>::TRACE_HLPR(T* szFormat, ...)
{
  va_list args;
  va_start(args, szFormat);
  int   bufSize;
  TCHAR szBuffer[_MAX_PATH*2];
  bufSize = wvsprintf(szBuffer, szFormat, args);
  _ASSERTE(bufSize < sizeof(szBuffer));
  ::OutputDebugString(szBuffer);
  va_end(args);
}



///////////////////////////////////////////////////////////////////////////////
// Classes used to handle strings.
///////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////
// TStringConverter: Template to 'hide' some functions for string conversions
// Note that methods that return types other than GUID must be
// manually freed with delete[] or SysFreeString as appropriate.
/////////////////////////////////////////////////////////////

template <class T = TCHAR>
class TStringConverter
{
public:
  static  LPSTR     WideToAnsi(LPCWSTR    src);
  static  LPWSTR    AnsiToWide(LPCSTR     src);
  static  LPWSTR    AnsiToOLESTR(LPCSTR   src);
  static  LPWSTR    WideToOLESTR(LPCWSTR  src);
  static  TCHAR*    strnewdup(const T*    src);
  static  GUID      AnsiToGUID(LPCTSTR    src);
  static  GUID      WideToGUID(LPCWSTR    src);
};

template <class T> GUID
TStringConverter<T>::WideToGUID(LPCWSTR src)
{
  GUID retval;
  OLECHAR* temp = WideToOLESTR(src);
  CLSIDFromString(temp, &retval);
  SysFreeString(temp);
  return retval;
}

template <class T> GUID
TStringConverter<T>::AnsiToGUID(LPCTSTR src)
{
  GUID retval;
  OLECHAR* temp = AnsiToOLESTR(src);
  CLSIDFromString(temp, &retval);
  SysFreeString(temp);
  return retval;
}

// Note: Return value must be deleted[]
template <class T> LPSTR
TStringConverter<T>::WideToAnsi(LPCWSTR src)
{
   int size = ::WideCharToMultiByte(CP_ACP, 0, src, -1, 0, 0, 0, 0);
   LPSTR dst = new char[size];
   size = ::WideCharToMultiByte(CP_ACP, 0, src, -1, dst, size, 0, 0);
   _ASSERTE(size != 0);
   return dst;
}

// NOTE: Return value must be passed to '::SysFreeString'
template <class T> OLECHAR*
TStringConverter<T>::AnsiToOLESTR(LPCSTR src)
{
   int size = ::MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, src, -1, 0, 0);
   LPWSTR dst = ::SysAllocStringLen(0, size);
   size = ::MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, src, -1, dst, size);
   _ASSERTE(size != 0);
   return dst;
}

// NOTE: Return value must be deleted[]
template <class T> LPWSTR
TStringConverter<T>::AnsiToWide(LPCSTR src)
{
   int size = ::MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, src, -1, 0, 0);
   LPWSTR dst = new wchar_t[size];
   size = ::MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, src, -1, dst, size);
   _ASSERTE(size != 0);
   return dst;
}

// NOTE: Return value must be  passed to '::SysFreeString'
template <class T> OLECHAR*
TStringConverter<T>::WideToOLESTR(LPCWSTR src)
{
   return ::SysAllocString(src);
}

// NOTE: Return value must be deleted[]
template <class T> TCHAR*
TStringConverter<T>::strnewdup(const T* str)
{
   _ASSERTE(str);
   return lstrcpy(new TCHAR[lstrlen(str)+1], str);
}


// Return value must be deleted[]
inline LPSTR WideToAnsi(LPCWSTR src)
{
  return TStringConverter<TCHAR>::WideToAnsi(src);
}

// NOTE: Return value must be passed to '::SysFreeString'
inline OLECHAR* AnsiToOLESTR(LPCSTR src)
{
  return TStringConverter<TCHAR>::AnsiToOLESTR(src);
}

// NOTE: Return value must be '::SysFreeString'
inline OLECHAR* WideToOLESTR(LPCWSTR src)
{
  return TStringConverter<TCHAR>::WideToOLESTR(src);
}

// NOTE: Return value must be delete[]
inline TCHAR* strnewdup(LPCTSTR str)
{
   _ASSERTE_(str);
   return TStringConverter<TCHAR>::strnewdup(str);
}

//////////////////////////////////////////////////////////
// TOleString --- smart pointer for BSTRs
/////////////////////////////////////////////////////////

// Wrapper for freeing BSTRs
//
class TOleString
{
public:
  explicit TOleString(BSTR bstr) : m_bstr(bstr) {}
  explicit TOleString(const CHAR *str) : m_bstr(str ? AnsiToOLESTR(str) : 0) {}
 ~TOleString() { ::SysFreeString(m_bstr); }

  operator BSTR() const { return m_bstr;}

private:
  TOleString(const TOleString&);
  TOleString& operator=(const TOleString&);

  BSTR     m_bstr;
};

/////////////////////////////////////////////////////////
// TCharBuff --- Cheap coder's quick buffer wrapper...
/////////////////////////////////////////////////////////

template <int LEN>
class TCharBuff
{
public:
  TCharBuff() : m_Data(new TCHAR[LEN])            { m_Data[0] = 0;   }
  TCharBuff(LPCTSTR src) : m_Data(new TCHAR[LEN]) { *this = src;     }
  TCharBuff(const TCharBuff& src) : m_Data(new TCHAR[LEN]) { *this = src;     }
 ~TCharBuff()                                     { delete[] m_Data; }

  operator LPCTSTR() const                        { return m_Data;      }
  static int   Len()                              { return LEN;         }
  bool  operator !() const                        { return m_Data[0]==0;}

  LPTSTR   Copy(LPCTSTR src)                      { return lstrcpyn(m_Data, src, LEN); }
  LPTSTR   Cat (LPCTSTR src)                      { return lstrcat(m_Data, src);       }

  TCharBuff& operator =(LPCTSTR src)              { Copy(src); return *this; }
  TCharBuff& operator =(const TCharBuff& src)     { Copy(src); return *this; }
  TCharBuff& operator+=(LPCTSTR src)              { Cat(src);  return *this; }

protected:
  LPTSTR    m_Data;
};



////////////////////////////////////////////////////////////////////////////////
// Pointers and DLLs, Initialization and system issues
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
// TPtrBase
// Base class for automation pointer management.
// Provides basic implementation for  smart pointer object.
///////////////////////////////////////////////////////////

template<class T>
class TPtrBase
{
public:
  // Methods implementing pointer semantics
  //
  T&  operator *  ()    const { _ASSERTE_(m_ptr); return *m_ptr; }
      operator T* ()    const { return m_ptr;}
      bool operator !() const { return m_ptr == 0; }
  T*   operator->()    const  { _ASSERTE_(m_ptr); return m_ptr;  }
  T**  operator &() /*const*/ { return &m_ptr; }

  // Comparison operators
  //
  bool operator == (T                 *rhs) const { return m_ptr == rhs;}
  bool operator == (const TPtrBase<T> &rhs) const { return m_ptr == rhs.m_ptr; }
  bool operator != (T                 *rhs) const { return m_ptr != rhs;}
  bool operator != (const TPtrBase<T> &rhs) const { return m_ptr != rhs.m_ptr; }

protected:
   TPtrBase()     : m_ptr(0) {}
   TPtrBase(T* p) : m_ptr(p) {}

   T* get        () const   { return m_ptr;    }
   T* release    ()         { return reset(0); }
   T* reset      (T* p = 0) { T* tmp = m_ptr; m_ptr = p; return tmp; }

   // Actual data
   T* m_ptr;

private:
    // Prevent new/delete
    void* operator new(size_t);
    void  operator delete(void*/*p*/){/*::delete p;*/};
};

//////////////////////////////////////////////////////////
// TPtr: Smart pointer object for non-array pointers
//////////////////////////////////////////////////////////

template<class T>
class TPtr : public TPtrBase<T>
{
public:
  TPtr()       : TPtrBase<T>()              {}
  TPtr(T* src) : TPtrBase<T>(src)           {}
  TPtr(const TPtr<T>& src): TPtrBase<T>(src.release()) {}
public:
 ~TPtr()                                          {clear(0);}

  // Assignment operators
  TPtr& operator = (TPtr<T>& src)
  {
    // Transfer ownership of pointer to receiver
    clear(src.release());
    return *this;
  }
  TPtr& operator = (T* src)
  {
    clear(src);
    return *this;
  }
  T*  operator& () const
  {
    return get();
  }

  // Clear object - free pointer
  void clear(T *src)
  {
    delete m_ptr;
    m_ptr = src;
  }
};

//////////////////////////////////////////////////////////
// TAPtr: Smart pointer object for array new'ed memory
//////////////////////////////////////////////////////////

template<class T>
class TAPtr : public TPtrBase<T>
{
public:
  TAPtr()             : TPtrBase<T>()              {}
  TAPtr(T      src[]) : TPtrBase<T>(src)           {}
  TAPtr(TAPtr<T>& src): TPtrBase<T>(src.release()) {}
 ~TAPtr()                                          {clear(0);}

  // Assignment operators
  TAPtr& operator = (TAPtr<T>& src)
  {
    // Transfer ownership of pointer to receiver
    clear(src.release());
    return *this;
  }
  TAPtr& operator = (T src[])
  {
    clear(src);
    return *this;
  }

  // Subscript operator (for array)
  T& operator [](int i) const
  {
    _ASSERTE_(m_ptr);
    return m_ptr[i];
  }

  // Clear object - free pointer
  void clear(T src[])
  {
    if (m_ptr)
      delete []m_ptr;
    m_ptr = src;
  }
};

////////////////////////////////////////////////////
// TDll: Wrapper class encapsulating a DLL
////////////////////////////////////////////////////

class TDll
{
public:
  TDll(LPCTSTR name) : m_Hinstance(::LoadLibrary(name)) {}
 ~TDll()
  {
    if (m_Hinstance)
      ::FreeLibrary(m_Hinstance);
  }

  operator HINSTANCE() const                      { return m_Hinstance; }
  FARPROC  GetProcAddress(LPCSTR funcName) const  { return ::GetProcAddress(*this, funcName); }

private:
  HINSTANCE   m_Hinstance;

  TDll(const TDll&);
  TDll& operator=(const TDll&);
};

//////////////////////////////////////////////////
// TDllProc: Encapsulates a DLL EntryPoint/FARPROC
//////////////////////////////////////////////////
class TDllProc
{
public:
  TDllProc(const TDll& dll, LPCSTR funcName)
  {
    m_Proc = dll.GetProcAddress(funcName);
  }
  operator bool() { return m_Proc != 0; }
protected:
  FARPROC   m_Proc;
};

////////////////////////////////////////////////////////////////
// FARPROC that's CDECL, returns HRESULT and takes one parameter
////////////////////////////////////////////////////////////////

template <class P1>
class TDllProc1 : public TDllProc
{
public:
  TDllProc1(const TDll& dll , LPCTSTR funcName) : TDllProc(dll, funcName) {};
  HRESULT operator ()(P1 erste)
  {
    typedef HRESULT (__cdecl* outproc)(P1 erste);
    return ((outproc)m_Proc)(erste);
  }
};

//////////////////////////////////////////////////////////////////
// FARPROC that's STDCALL, returns HRESULT and take two parameters
//////////////////////////////////////////////////////////////////

template <class P1, class P2>
class TDllStdProc2 : public TDllProc
{
public:
  TDllStdProc2(const TDll& dll, LPCTSTR funcName) : TDllProc(dll, funcName) {}
  HRESULT operator () (P1 p1, P2 p2)
  {
    typedef HRESULT (__stdcall* outproc)(P1 p1, P2 p2);
    return ((outproc)m_Proc)(p1, p2);
  }
};

//////////////////////////////////////////////////////////////////
// FARPROC that's CDECL, returns a void pointer,
// and takes two parameters
//////////////////////////////////////////////////////////////////

template <class P1, class P2>
class TDllProc2 : public TDllProc
{
public:
  TDllProc2(const TDll& dll, LPCTSTR funcName) : TDllProc(dll, funcName) {}
  void* operator () (P1 p1, P2 p2)
  {
    typedef void* (__cdecl* outproc)(P1 p1, P2 p2);
    return ((outproc)m_Proc)(p1, p2);
  }
};

////////////////////////////////////////////////////////
// TInitOle: Simple object to initialize and unintialize
// Ole in a safe fashion
////////////////////////////////////////////////////////

template <class T>
class TInitOleT
{
public:
  TInitOleT(COINIT initFlag = m_DefaultInitFlag)
  {
#if defined(__DLL__)
    init = false;
#else
    // Avoid CoInitializeEx wherever possible - It's not available on shipping WIN95
#if defined(_ATL_COINIT_MULTITHREADED)
    HRESULT hr_Initializing_OLE = ::CoInitializeEx(0, initFlag);
#else
    _ASSERTE_((initFlag & COINIT_MULTITHREADED) == 0 /* User requested MT but macro was not properly defined */);
    HRESULT hr_Initializing_OLE = ::CoInitialize(0);
#endif
    /* OLECHECK(hr_Initializing_OLE); */
    init = SUCCEEDED(hr_Initializing_OLE);
#endif
  }
 ~TInitOleT()
  {
    if (init)
      ::CoUninitialize();
  }

  // Methods to test whether initialization was succcessful
  operator bool  () const { return init;          }
  bool operator! () const { return init == false; }

  // static members
  static  COINIT  m_DefaultInitFlag;
  static  void    Init();

protected:
  // Flags if initialization was successful
  bool init;

private:
  // Prevent accidental copy to ensure equal numbers of Init/UnInit
  TInitOleT(const TInitOleT<T>&);
  TInitOleT<T>& operator = (const TInitOleT<T>&);
};

///////////////////////////////////////////
// Default flag when initializing OLE
///////////////////////////////////////////

#if !defined(_ATL_COINIT_MULTITHREADED)
template <class T> COINIT
TInitOleT<T>::m_DefaultInitFlag = COINIT_APARTMENTTHREADED;
#else
template <class T> COINIT
TInitOleT<T>::m_DefaultInitFlag = COINIT_MULTITHREADED;
#endif

// Creates a single instance that initializes OLE
template <class T> void
TInitOleT<T>::Init()
{
  static TInitOleT<T> instance(m_DefaultInitFlag);
}

// TInitOle is backward compatible with v3.0's TInitOle
typedef TInitOleT</*Pick a type*/int> TInitOle;

//////////////////////////////////////////////////////////
// TCOMCriticalSection --- provides locking and unlocking
/////////////////////////////////////////////////////////

class TCOMCriticalSection
{
public:
  TCOMCriticalSection() { ::InitializeCriticalSection(&m_cs); }
 ~TCOMCriticalSection() { ::DeleteCriticalSection(&m_cs); }

  class Lock
  {
  public:
    Lock(TCOMCriticalSection& c);
   ~Lock();
    void Relinquish();

  private:
    Lock(const Lock&);
    Lock& operator=(const Lock&);

    TCOMCriticalSection* m_cs;
  };

  friend class Lock;

private:
  CRITICAL_SECTION m_cs;

  TCOMCriticalSection(const TCOMCriticalSection&);
  TCOMCriticalSection& operator=(const TCOMCriticalSection&);

  void lock() {::EnterCriticalSection(&m_cs);}
  void unlock() {::LeaveCriticalSection(&m_cs);}
};

inline TCOMCriticalSection::Lock::Lock(TCOMCriticalSection& c) : m_cs(&c)
{
  m_cs->lock();
}

inline TCOMCriticalSection::Lock::~Lock()
{
  if (m_cs)
    m_cs->unlock();
}

inline void TCOMCriticalSection::Lock::Relinquish()
{
  if (m_cs)
  {
    m_cs->unlock();
    m_cs = NULL;
  }
}

///////////////////////////////////////////////////////////////////
// IsComPlusPlatform --- detects platform status
// As of October 1999, Com+ is only supported under windows NT 5.
// If ComPlus support is added in future versions of the win9x
// product line, modify this function and recompile.
///////////////////////////////////////////////////////////////////

#ifdef _WINNT_
template <class T>
bool IsComPlusPlatform() {
  OSVERSIONINFO Ver;
  GetVersionEx(&Ver);
  if  ( (Ver.dwPlatformId == VER_PLATFORM_WIN32_NT)
      && (Ver.dwMajorVersion >= 5) )
      {
        return true;
      }
  else return false;
}
#endif _WINNT_



///////////////////////////////////////////////////////////////////////////////
// Type wrappers which don't depend on Variant support
///////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////
// TOLEBOOL --- Boolean
// VARIANT_BOOL is really just a short. Therefore it's not distinguishable from a
// VT_I2. Most servers will take VT_I2 in a VARIANT when expecting a BOOLEAN.
// However, some (such as Excel97) won't. So to distinguish, we'll expose VT_BOOL
// as TOLEBOOL instead of VARIANT_BOOL.
//
// (The main issue is sizeof(WORD) != sizeof(bool) - hence VT_BOOL|VT_BYREF would
//  break if we used C++ bool type for OLE VT_BOOL parameters.)
//////////////////////////////////////////////////

class TOLEBOOL
{
public:
  TOLEBOOL(bool flag = false)   : m_VariantBool(flag ? VARIANT_TRUE : VARIANT_FALSE) {}
  TOLEBOOL(VARIANT_BOOL flag)   : m_VariantBool(flag ? VARIANT_TRUE : VARIANT_FALSE) {}
  TOLEBOOL(int flag)            : m_VariantBool(flag ? VARIANT_TRUE : VARIANT_FALSE) {}

  TOLEBOOL& operator=(bool flag)
  {
    m_VariantBool = flag ? VARIANT_TRUE : VARIANT_FALSE;
    return *this;
  }
  TOLEBOOL& operator=(VARIANT_BOOL flag)
  {
    m_VariantBool = flag ? VARIANT_TRUE : VARIANT_FALSE;
    return *this;
  }
  TOLEBOOL& operator=(int flag)
  {
    m_VariantBool = flag ? VARIANT_TRUE : VARIANT_FALSE;
    return *this;
  }

  bool operator==(bool val)         { return val ? (m_VariantBool != VARIANT_FALSE) : (m_VariantBool == VARIANT_FALSE); }
  bool operator==(VARIANT_BOOL val) { return m_VariantBool == val; }

  operator bool () const          { return m_VariantBool != VARIANT_FALSE;  }
  operator VARIANT_BOOL () const  { return (m_VariantBool != VARIANT_FALSE) ? VARIANT_TRUE : VARIANT_FALSE; }

protected:
  VARIANT_BOOL  m_VariantBool;
};


///////////////////////////////////////////////////////////////////////////////
// Variant support classes and typedefs
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// The following macros utilize the Variant access macros defined in OLEAUTO.H
// to set the VARTYPE (vt) and the related variable at once. For example:
//
//    V_TYPE_VAR(CY, amount) expands to           vt         = VT_CY;
//                                                V_CY(this) = amount;
///////////////////////////////////////////////////////////////////////////////
#if !defined(SET_VTYPE_AND_VAR)
#define SET_VTYPE_AND_VAR(type, val)    vt = VT_ ## type ;            \
                                        V_ ## type (this) = val;
#endif
#if !defined(SET_VTYPE_AND_VARREF)
#define SET_VTYPE_AND_VARREF(type, val) vt = VT_ ## type | VT_BYREF;  \
                                        V_ ## type ## REF (this) = val;
#endif

//////////////////////////////////////////////////////////////////////////////
//  TVariantT is intended to be used as a general-purpose VARIANT wrapper.
////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////
// TVariantT
// ========
// Templatized VARIANT support. T must be a VARIANT or VARIANT-derived type
///////////////////////////////////////////////////////////////////////////////
template <class T, bool CLEANUP>
class TVariantT : public T
{
public:
  TVariantT()
  {
    ::VariantInit(this);
  }

 ~TVariantT()
  {
    if (CLEANUP)
    {
      ::VariantClear(this);
    }
  }

  TVariantT(const TVariantT& src)
  {
    ::VariantInit(this);
    ::VariantCopy(this, (VARIANT*)&src);
  }

  TVariantT(bool src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(BOOL, src ? VARIANT_TRUE : VARIANT_FALSE);
  }
  TVariantT(const TOLEBOOL& src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(BOOL, src ? VARIANT_TRUE : VARIANT_FALSE);
  }
  TVariantT(char src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(I1, src);
  }
  TVariantT(signed char src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(I1, src);
  }
  TVariantT(unsigned char src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(UI1, src);
  }
  TVariantT(short src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(I2, src);
  }
  TVariantT(unsigned short src, bool isBoolean = false)
  {
    ::VariantInit(this);
    if (isBoolean)
    {
      SET_VTYPE_AND_VAR(BOOL, src);
    }
    else
    {
      SET_VTYPE_AND_VAR(UI2, src);
    }
  }
  TVariantT(int src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(I4, src);
  }
  TVariantT(unsigned int src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(UI4, src);
  }
  TVariantT(long src, bool isError = false)
  {
    ::VariantInit(this);
    if (isError)
    {
      SET_VTYPE_AND_VAR(ERROR, src);
    }
    else
    {
      SET_VTYPE_AND_VAR(I4, src);
    }
  }
  TVariantT(unsigned long src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(UI4, src);
  }
  TVariantT(float src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(R4, src);
  }
  TVariantT(double src, bool isDate = false)
  {
    ::VariantInit(this);
    if (isDate)
    {
      SET_VTYPE_AND_VAR(DATE, src);
    }
    else
    {
      SET_VTYPE_AND_VAR(R8, src);
    }
  }
  TVariantT(long double src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(R8, double(src));
  }

  // Constructors from OLE structures.
  TVariantT(const CURRENCY& src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(CY, src);
  }
  TVariantT(SAFEARRAY& src)
  {
    ::VariantInit(this);
    SetSAFEARRAY(&src);
  }
  TVariantT(SAFEARRAY* src)
  {
    ::VariantInit(this);
    SetSAFEARRAY(src);
  }
  TVariantT(const VARIANT& src, bool copy = true)
  {
    ::VariantInit(this);
    if (copy)
    {
      ::VariantCopy(this, const_cast<VARIANTARG*>(&src));
    }
    else
    {
      SET_VTYPE_AND_VARREF(VARIANT, const_cast<VARIANTARG*>(&src));
    }
  }
  TVariantT(VARIANT* src)
  {
    ::VariantInit(this);
    ::VariantCopy(this, src);
  }

  // Ctr - From VCL utility classes (Members are exposed only of VCL headers have been included)
  //
#if defined(SYSVARI_H)
  TVariantT(const System::Variant& rhs)
  {
    ::VariantInit(this);
    *this = rhs;
  }
#endif
#if defined(DSTRING_H)
  TVariantT(const AnsiString& src)
  {
    ::VariantInit(this);
    *this = src.c_str();
  }
#endif
#if defined(SYSCURR_H)
  TVariantT(const Currency& src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(CY, *(reinterpret_cast<tagCY*>(&(const_cast<Currency&>(src).Val))))
  }
  TVariantT(Currency* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(CY, reinterpret_cast<tagCY*>(&(src->Val)));
  }
#endif
#if defined(SYSTDATE_H)
  TVariantT(const TDateTime& src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(DATE, src);
  }
  TVariantT(TDateTime* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(DATE, reinterpret_cast<DATE*>(src));
  }
#endif
#if defined(WSTRING_H)
  TVariantT(const WideString& src)
  {
	::VariantInit(this);
	SET_VTYPE_AND_VAR(BSTR, src.Copy());
  }
#endif
#if defined(SYSTOBJ_H)
  // Ref-counted Dispatch interface object
  TVariantT(const System::DelphiInterface<IDispatch>& src)
  {
	::VariantInit(this);
	if (!!src)
	  src->AddRef();
	SET_VTYPE_AND_VAR(DISPATCH, src);
  }
#endif

  // Asciiz pointer
  TVariantT(const char* src)  // Treated as pointer Asciiz string
  {
    ::VariantInit(this);
    int size = ::MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, src, -1, 0, 0);
    LPWSTR dst = ::SysAllocStringLen(0, size);
    ::MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, src, -1, dst, size);
    SET_VTYPE_AND_VAR(BSTR, dst);
  }

  // Ctr - OLE ptrs

  // By default calls SysAllocString. Set isSysString = true to
  // override.
  TVariantT(wchar_t* src, bool isSysString = false) // BSTR support
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VAR(BSTR, isSysString ? src : ::SysAllocString(src));
  }

  TVariantT(IUnknown* src)
  {
    ::VariantInit(this);
    if (src)
      src->AddRef();
    SET_VTYPE_AND_VAR(UNKNOWN, src);
  }
  TVariantT(IDispatch* src)
  {
    ::VariantInit(this);
    if (src)
      src->AddRef();
    SET_VTYPE_AND_VAR(DISPATCH, src);
  }


  //By ref constructors

  // NOTE: We cannot take a bool* since the sizes of VARIANT_BOOL and bool
  //       differ. Instead we'll take a TOLEBOOL. Taking a VARIANT_BOOL*
  //       is not distinguishable from a short pointer.
  //
  TVariantT(TOLEBOOL* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(BOOL, src);
  }
  TVariantT(signed char* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(I1, src);
  }
  TVariantT(unsigned char* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(UI1, src);
  }
  TVariantT(short* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(I2, src);
  }
  TVariantT(unsigned short* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(UI2, src);
  }
  TVariantT(int* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(I4, src);
  }
  TVariantT(unsigned int* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(UI4, src);
  }
  TVariantT(long* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(I4, src);
  }
  TVariantT(unsigned long* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(UI4, src);
  }
  TVariantT(float* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(R4, src);
  }
  TVariantT(double* src, bool isDate = false)
  {
    ::VariantInit(this);
    if (isDate)
    {
      SET_VTYPE_AND_VARREF(DATE, src);
    }
    else
    {
      SET_VTYPE_AND_VARREF(R8, src);
    }
  }
  TVariantT(CURRENCY* src)
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(CY, src);
  }
  TVariantT(SAFEARRAY** src)
  {
    ::VariantInit(this);
    SetSAFEARRAY(src);
  }
  TVariantT(wchar_t** src)  // VT_BSTR|VT_BYREF
  {
    ::VariantInit(this);
    SET_VTYPE_AND_VARREF(BSTR, src);
  }

  // Helpers for SAFEARRAY which do not copy the underlying array.
  void SetSAFEARRAY(SAFEARRAY *psa)
  {
    VARTYPE _vt;
    ::SafeArrayGetVartype(psa, &_vt);
    vt = VT_ARRAY|_vt;
    V_ARRAY(this) = psa;
  }
  void SetSAFEARRAY(SAFEARRAY **ppsa)
  {
    VARTYPE _vt;
    ::SafeArrayGetVartype(*ppsa, &_vt);
    vt = VT_ARRAY|VT_BYREF|_vt;
    V_ARRAYREF(this) = ppsa;
  }

  TVariantT& operator =(const TVariantT &rhs)
  {
    if (&rhs != this)
    {
      ::VariantClear(this);
      ::VariantCopy(this, const_cast<TVariant*>(&rhs));
    }
    return *this;
  }
  TVariantT& operator =(bool src)
  {
    ::VariantClear(this);
    SET_VTYPE_AND_VAR(BOOL, src ? VARIANT_TRUE : VARIANT_FALSE);
    return *this;
  }
  TVariantT& operator =(const TOLEBOOL& src)
  {
    ::VariantClear(this);
    SET_VTYPE_AND_VAR(BOOL, src ? VARIANT_TRUE : VARIANT_FALSE);
    return *this;
  }
  TVariantT& operator =(char src)
  {
    ::VariantClear(this);
    SET_VTYPE_AND_VAR(I1, src);
    return *this;
  }
  TVariantT& operator =(signed char src)
  {
    ::VariantClear(this);
    SET_VTYPE_AND_VAR(I1, src);
    return *this;
  }
  TVariantT& operator =(unsigned char src)
  {
    ::VariantClear(this);
    SET_VTYPE_AND_VAR(UI1, src);
    return *this;
  }
  TVariantT& operator =(short src)
  {
    ::VariantClear(this);
    SET_VTYPE_AND_VAR(I2, src);
    return *this;
  }
  TVariantT& operator =(unsigned short src)
  {
    ::VariantClear(this);
    SET_VTYPE_AND_VAR(UI2, src);
    return *this;
  }
  TVariantT& operator =(int src)
  {
    ::VariantClear(this);
    SET_VTYPE_AND_VAR(I4, src);
    return *this;
  }
  TVariantT& operator =(unsigned int src)
  {
    ::VariantClear(this);
    SET_VTYPE_AND_VAR(UI4, src);
    return *this;
  }
  TVariantT& operator =(long src)
  {
    ::VariantClear(this);
    SET_VTYPE_AND_VAR(I4, src);
    return *this;
  }
  TVariantT& operator =(unsigned long src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VAR(UI4, src);
	return *this;
  }
  TVariantT& operator =(float src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VAR(R4, src);
	return *this;
  }
  TVariantT& operator =(double src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VAR(R8, src);
	return *this;
  }
  TVariantT& operator =(const CURRENCY& src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VAR(CY, src);
	return *this;
  }
  TVariantT& operator =(SAFEARRAY* src)
  {
	::VariantClear(this);
	SetSAFEARRAY(src);
	return *this;
  }
  TVariantT& operator =(SAFEARRAY& src)
  {
	::VariantClear(this);
	SetSAFEARRAY(&src);
	return *this;
  }
  TVariantT& operator =(const VARIANT& rhs)
  {
	::VariantClear(this);
	::VariantCopy(this, &rhs);
	return *this;
  }

  TVariantT& operator =(VARIANT* rhs)
  {
	::VariantClear(this);
	// Can only have one level of indirection with VT_VARIANT
	//
	if (rhs && rhs->vt != VT_VARIANT && rhs->vt != (VT_VARIANT|VT_BYREF))
	{
	  SET_VTYPE_AND_VARREF(VARIANT, rhs);
	}
	else
	{
	  ::VariantCopy(this, rhs);
	}
	return *this;
  }

#if defined(SYSVARI_H)
  TVariantT& operator =(const System::Variant& rhs)
  {
	::VariantClear(this);
	System::Variant v(rhs.Sanitized());
	::VariantCopy(this, reinterpret_cast<VARIANT*>(&v));
	return *this;
  }
  TVariantT& operator =(const System::OleVariant& rhs)
  {
	::VariantClear(this);
	::VariantCopy(this, reinterpret_cast<VARIANT*>(&(const_cast<System::OleVariant&>(rhs))));
	return *this;
  }
  TVariantT& operator =(System::Variant* rhs)
  {
	::VariantClear(this);
	// Can only have one level of indirection with VT_VARIANT
	//
	if (rhs && rhs->vt != VT_VARIANT && rhs->vt != (VT_VARIANT|VT_BYREF))
	{
	  SET_VTYPE_AND_VARREF(VARIANT, reinterpret_cast<VARIANT*>(rhs));
	}
	else
	{
	  ::VariantCopy(this, reinterpret_cast<VARIANT*>(rhs));
	}
	return *this;
  }
#endif
#if defined(DSTRING_H)
  TVariantT& operator=(const AnsiString& src)
  {
	::VariantClear(this);
	*this = src.c_str();
	return *this;
  }
#endif
#if defined(SYSCURR_H)
  TVariantT& operator=(const Currency& src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VAR(CY, *(reinterpret_cast<tagCY*>(&(const_cast<Currency&>(src).Val))))
	return *this;
  }
#endif
#if defined(SYSTDATE_H)
  TVariantT& operator=(const TDateTime& src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VAR(DATE, src);
	return *this;
  }
#endif
#if defined(WSTRING_H)
  TVariantT& operator=(const WideString& src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VAR(BSTR, src.Copy());
	return *this;
  }
#endif
#if defined(SYSTOBJ_H)
  TVariantT& operator=(const System::DelphiInterface<IDispatch>& src)
  {
	if (!!src)
	  src->AddRef();
	::VariantClear(this);
	SET_VTYPE_AND_VAR(DISPATCH, src/*Relies on fact that DelphiInterface<> does not AddRef when handing out intf.*/);
	return *this;
  }
#endif

  TVariantT& operator =(wchar_t* src) // BSTR support
  {
	::VariantClear(this);
#if 0	// The relentless dilemma of whether TVariant takes ownership of the BSTR.
	SET_VTYPE_AND_VAR(BSTR, src);
#else
	SET_VTYPE_AND_VAR(BSTR, ::SysAllocString(src));
#endif
	return *this;
  }
  TVariantT& operator =(IUnknown* src)
  {
	if (src)
	  src->AddRef();
	::VariantClear(this);
	SET_VTYPE_AND_VAR(UNKNOWN, src);
	return *this;
  }
  TVariantT& operator =(IDispatch* src)
  {
	if (src)
	  src->AddRef();
	::VariantClear(this);
	SET_VTYPE_AND_VAR(DISPATCH, src);
	return *this;
  }

  // By ref Assignment
  // NOTE: We cannot take a 'bool*' - the size of VARIANT_BOOL and bool differ
  TVariantT& operator =(TOLEBOOL* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(BOOL, (VARIANT_BOOL*)src);
	return *this;
  }
  TVariantT& operator =(const char* src)           // Treated as pointer Asciiz string
  {
	::VariantClear(this);
	SET_VTYPE_AND_VAR(BSTR, AnsiToOLESTR(src));
	return *this;
  }
  TVariantT& operator =(signed char* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(I1, reinterpret_cast<char*>(src));
	return *this;
  }
  TVariantT& operator =(unsigned char* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(UI1, src);
	return *this;
  }
  TVariantT& operator =(short* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(I2, src);
	return *this;
  }
  TVariantT& operator =(unsigned short* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(UI2, src);
	return *this;
  }
  TVariantT& operator =(int* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(I4, (long*)src);
	return *this;
  }
  TVariantT& operator =(unsigned int* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(UI4, reinterpret_cast<unsigned long*>(src));
	return *this;
  }
  TVariantT& operator =(long* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(I4, src);
	return *this;
  }
  TVariantT& operator =(unsigned long* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(UI4, src);
	return *this;
  }
  TVariantT& operator =(float* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(R4, src);
	return *this;
  }
  TVariantT& operator =(double* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(R8, src);
	return *this;
  }
  TVariantT& operator =(CURRENCY* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(CY, src);
	return *this;
  }
  TVariantT& operator =(SAFEARRAY** src)
  {
	::VariantClear(this);
	SetSAFEARRAY(src);
	return *this;
  }
  TVariantT& operator =(BSTR* /*[wchar_t**]*/ src) // VT_BSTR|VT_BYREF
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(BSTR, src);
	return *this;
  }
  TVariantT& operator =(IUnknown** src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(UNKNOWN, src);
	return *this;
  }
  TVariantT& operator =(IDispatch** src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(DISPATCH, src);
	return *this;
  }

#if defined(SYSCURR_H)
  TVariantT& operator=(Currency* src)
  {
	::VariantClear(this);
	if(src)
	  SET_VTYPE_AND_VARREF(CY, reinterpret_cast<tagCY*>(&(src->Val)));
	return* this;
  }
#endif
#if defined(SYSTDATE_H)
  TVariantT& operator=(TDateTime* src)
  {
	::VariantClear(this);
	SET_VTYPE_AND_VARREF(DATE, &src->Val);
	return *this;
  }
#endif
#if defined(SYSTOBJ_H)
  TVariantT
  & operator=(const System::DelphiInterface<IDispatch>* src)
  {
	::VariantClear(this);
	if (!!src)
	  SET_VTYPE_AND_VARREF(DISPATCH, src);
	return *this;
  }
#endif

  HRESULT   ChangeType(VARTYPE vtNew, const VARIANT& src)
  {
	return ::VariantChangeType(this, &src, 0, vtNew);
  }
  HRESULT   ChangeType(VARTYPE vtNew)
  {
	return ::VariantChangeType(this, this, 0, vtNew);
  }

  // Returns pointer to base Variant type when Variant holds other Variant
  //
  TVariantT* GetBaseVariant();

  // Conversion operators
  operator bool() const
  {
	TVariant v(*this);
	v.ChangeType(VT_BOOL);
	bool retval = V_BOOL(&v) != VARIANT_FALSE;
	return retval;
  }
  operator TOLEBOOL() const
  {
	return TOLEBOOL(bool(*this));
  }
  operator char() const
  {
	TVariant v(*this);
	v.ChangeType(VT_I1);
	return V_I1(&v);
  }
  operator signed char() const
  {
	TVariant v(*this);
	v.ChangeType(VT_I1);
	return V_I1(&v);
  }
  operator unsigned char() const
  {
	TVariant v(*this);
	v.ChangeType(VT_UI1);
	return V_UI1(&v);
  }
  operator short() const
  {
	TVariant v(*this);
	v.ChangeType(VT_I2);
	return V_I2(&v);
  }
  operator unsigned short() const
  {
	TVariant v(*this);
	v.ChangeType(VT_UI2);
	return V_UI2(&v);
  }
  operator int() const
  {
	TVariant v(*this);
	v.ChangeType(VT_I4);
	return V_I4(&v);
  }
  operator unsigned int() const
  {
	TVariant v(*this);
	v.ChangeType(VT_UI4);
	return V_UI4(&v);
  }
  operator long() const
  {
	TVariant v(*this);
	v.ChangeType(VT_I4);
	return V_I4(&v);
  }
  operator unsigned long() const
  {
	TVariant v(*this);
	v.ChangeType(VT_UI4);
	return V_UI4(&v);
  }
  operator float() const
  {
	TVariant v(*this);
	v.ChangeType(VT_R4);
	return V_R4(&v);
  }
  operator double() const
  {
	TVariant v(*this);
	v.ChangeType(VT_R8);
	return V_R8(&v);
  }
#if defined(DSTRING_H)
  operator AnsiString() const;
#endif
#if defined(WSTRING_H)
  operator WideString() const;
#endif
#if defined(SYSCURR_H)
  operator Currency() const
  {
	TVariant v(*this);
	v.ChangeType(VT_CY);
	Currency retval;
	retval.Val = V_CY(&v).int64;
	return retval;
  }
#endif
#if defined(SYSTDATE_H)
  operator TDateTime() const
  {
	TVariant v(*this);
	v.ChangeType(VT_DATE);
	return TDateTime(V_DATE(&v));
  }
#endif

  operator CURRENCY() const
  {
	TVariant v(*this);
	v.ChangeType(VT_CY);
	return V_CY(&v);
  }

  // NOTE: Caller must free SysString
  operator wchar_t*() const
  {
	TVariant v(*this);
	v.ChangeType(VT_BSTR);
	return ::SysAllocString(V_BSTR(&v));
  }

  operator IUnknown*();
  operator IDispatch*();

  // by ref conversion operators
  /* operator char*(); */  // Dangerous - easily used as string instead of VT_I1|VT_BYREF

  operator TOLEBOOL*()
  {
	if (vt == (VT_BOOL|VT_BYREF))
	  return (TOLEBOOL*)V_BOOLREF(this);
	else if (vt == VT_BOOL)
	  return (TOLEBOOL*)&(V_BOOL(this));
	return NULL;
  }
  operator signed char*()
  {
	if (vt == (VT_I1|VT_BYREF))
	  return (signed char*)V_I1REF(this);
	else if (vt == VT_I1)
	  return (signed char*)&(V_I1(this));
	return NULL;
  }
  operator unsigned char*()
  {
	if (vt == (VT_UI1 | VT_BYREF))
	  return V_UI1REF(this);
	else if (vt == VT_UI1)
	  return &(V_UI1(this));
	return NULL;
  }
  operator short*()
  {
	if (vt == (VT_I2|VT_BYREF))
	  return V_I2REF(this);
	else if (vt == VT_I2)
	  return &(V_I2(this));
	return NULL;
  }
  operator unsigned short*()
  {
	if (vt == (VT_UI2|VT_BYREF))
	  return V_UI2REF(this);
	else if (vt == VT_UI2)
	  return &(V_UI2(this));
	return NULL;
  }
  operator int*()
  {
	if (vt == (VT_I4|VT_BYREF))
	  return (int*)V_I4REF(this);
	else if (vt == VT_I4)
	  return (int*)&(V_I4(this));
	return NULL;
  }
  operator unsigned int*()
  {
	if (vt == (VT_UI4|VT_BYREF))
	  return (unsigned int*)V_UI4REF(this);
	else if (vt == VT_UI4)
	  return (unsigned int*)&(V_UI4(this));
	return NULL;
  }

  operator long*()
  {
	_ASSERTE(vt!= VT_UNKNOWN);
	_ASSERTE(vt!= VT_DISPATCH);
	_ASSERTE(vt!= (VT_UNKNOWN|VT_BYREF));
	_ASSERTE(vt!= (VT_DISPATCH|VT_BYREF));

	if (vt == (VT_UI4|VT_BYREF)) return (long*)V_UI4REF(this);
	else if (vt == VT_UI4) return (long*)&(V_UI4(this));
	return NULL;
  }

  operator float*()
  {
	if (vt == (VT_R4|VT_BYREF))
	  return V_R4REF(this);
	else if (vt == VT_R4)
	  return &(V_R4(this));
	return NULL;
  }
  operator double*()
  {
	if (vt == (VT_R8|VT_BYREF))
	  return V_R8REF(this);
	else if (vt == VT_R8)
	  return &(V_R8(this));
	return NULL;
  }
  operator wchar_t**()
  {
	if (vt == (VT_BSTR|VT_BYREF))
	  return V_BSTRREF(this);
	else if (vt == VT_BSTR)
	  return &(V_BSTR(this));
	return NULL;
  }
  operator VARIANT*()
  {
	return reinterpret_cast<VARIANT*>(GetBaseVariant());
  }

  // Returns plain VARIANT - Useful when you want
  // to pass ownership of data to someone else
  VARIANT Copy() const
  {
	VARIANT v;
	::VariantInit(&v);
	::VariantCopy(&v, this);
	return v;
  }

  // NOTE: Caller must destroy SAFEARRAY*
  operator SAFEARRAY*()
  {
	SAFEARRAY *pSAOut = 0;
	if (vt & VT_ARRAY)
	{
	  if (vt & VT_BYREF)
		::SafeArrayCopy(*V_ARRAYREF(this), &pSAOut);
	  else
		::SafeArrayCopy(V_ARRAY(this), &pSAOut);
	}
	return pSAOut;
  }

  /*operator CURRENCY*()       const;*/
  /*operator SAFEARRAY**()     const;*/

#if defined(SYSCURR_H)
  operator Currency*()
  {
	if (vt==(VT_CY|VT_BYREF))
	  return reinterpret_cast<Currency*>(pcyVal);
	else if (vt==VT_CY)
	  return reinterpret_cast<Currency*>(&cyVal);
	return NULL;
  }
#endif
#if defined(SYSTDATE_H)
  operator TDateTime*()
  {
	if (vt==(VT_DATE|VT_BYREF))
	  return reinterpret_cast<TDateTime*>(pdate);
	else if (vt==VT_DATE)
	  return reinterpret_cast<TDateTime*>(&date);
	return NULL;
  }
#endif

  // Generic == operator (NOTE: Relies on conversion operator for TYPE)
  //
  template <class TYPE>
  bool operator == (TYPE rhs)
  {
	TVariant tmp(*this);
	return TYPE(tmp) == rhs;
  }
};

// Returns 'base-most' VARIANT pointed to by a TBaseVariantT instance
// (i.e. skip cases where VARIANT points to other VARIANT - VT_VARIANT)
//
template <class T, bool CLEANUP>
TVariantT<T, CLEANUP>* TVariantT<T, CLEANUP>::GetBaseVariant()
{
  TVariantT *pVar = this;

  // NOTE: Technically there could only be one level of indirection for VT_VARIANT
  //       Additionally, VT_VARIANT should always be used in combination with VT_BYREF
  //       However, it does not hurt to catch multiple indirection or check a simple
  //       VT_VARIANT VARTYPE. Never know what's being packed and sent down out there
  //
  while (((pVar->vt == VT_VARIANT) || (pVar->vt == (VT_VARIANT|VT_BYREF))) && (V_VARIANTREF(pVar)))
	pVar = reinterpret_cast<TVariantT*>(V_VARIANTREF(pVar));

  return pVar;
}


// Extracts an IUnknown* from the TBaseVariantT instance.
// NOTE: Caller must 'Release' interface.
//
template <class T, bool CLEANUP>
TVariantT<T, CLEANUP>::operator IUnknown*()
{
  // Handle easy case right away
  //
  if (vt==VT_NULL || vt==VT_EMPTY)
    return 0;

  IDispatch* disp;
  IUnknown*  punk = 0;
  TVariantT*  pVar = GetBaseVariant();

  // Get Data out of Variant
  //
  switch(pVar->vt)
  {
	case VT_UNKNOWN:
	case VT_UNKNOWN|VT_BYREF:
	  punk = (vt==VT_UNKNOWN ? V_UNKNOWN(pVar) : (*(V_UNKNOWNREF(pVar))));
	  punk->AddRef();
	  return punk;

	case VT_DISPATCH:
	case VT_DISPATCH|VT_BYREF:
	  disp = (vt==VT_DISPATCH ? V_DISPATCH(pVar) : (*(V_DISPATCHREF(pVar))));
	  if (disp)
		disp->QueryInterface(IID_IUnknown, (LPVOID*)&punk);
	  return punk;

	// Hopefully, we'll never get here, but as last resort
	//
	default:
	  TVariant v(*this);
	  v.ChangeType(VT_UNKNOWN);
	  V_UNKNOWN(&v)->AddRef();
	  return V_UNKNOWN(&v);
  }
}


// Extracts an IDispatch* from the TBaseVariantT instance.
// NOTE: Caller must 'Release' interface.
//
template <class T, bool CLEANUP>
TVariantT<T, CLEANUP>::operator IDispatch*()
{
  // Handle easy case right away
  //
  if (vt==VT_NULL || vt==VT_EMPTY)
    return 0;

  IUnknown*  punk;
  IDispatch* disp= 0;
  TVariantT*  pVar= GetBaseVariant();

  // Get data out of Variant
  //
  switch(pVar->vt)
  {
	case VT_DISPATCH:
	case VT_DISPATCH|VT_BYREF:
	  disp = (vt==VT_DISPATCH ? V_DISPATCH(pVar) : (*(V_DISPATCHREF(pVar))));
	  if (disp)
		disp->AddRef();
	  return disp;

	case VT_UNKNOWN:
	case VT_UNKNOWN|VT_BYREF:
	  punk = (vt==VT_UNKNOWN ? V_UNKNOWN(pVar) : (*(V_UNKNOWNREF(pVar))));
	  punk->QueryInterface(IID_IDispatch, (LPVOID*)&disp);
	  return disp;

	default:
	  TVariant v(*pVar);
	  v.ChangeType(VT_DISPATCH);
	  V_DISPATCH(&v)->AddRef();
	  return V_DISPATCH(&v);
  }
}

#if defined(DSTRING_H)
template <class T, bool CLEANUP>
TVariantT<T, CLEANUP>::operator AnsiString() const
{
	TVariant v(*this);
	v.ChangeType(VT_BSTR);
	return AnsiString(V_BSTR(&v));
}
#endif
#if defined(WSTRING_H)
template <class T, bool CLEANUP>
TVariantT<T, CLEANUP>::operator WideString() const
{
	TVariant v(*this);
	v.ChangeType(VT_BSTR);
	// NOTE: The 'WideString(const wchar_t*)' constructor
	//       makes a copy of the data passed. So here
	//       we don't need to pass a copy of the BSTR
	//       we own!
	return WideString(V_BSTR(&v));
}
#endif

// typedefs of default Variant wrapper types.

typedef TVariantInParamT<VARIANT, false> TVariantInParam;
typedef TVariantT<VARIANT, true>         TVariant;

#if !defined(__AUTOARGS_H)
typedef TVariantT<VARIANT, true>         VARIANTOBJ;
#endif


////////////////////////////////////////////////////////////////////////////////
// Interface Wrappers, Creators, and other High-level support
////////////////////////////////////////////////////////////////////////////////

// Helper class used to create Default Interface Wrapper of CoClasses
// (Used by Code generated by TLIBIMP)
class CoClassCreator
{
public:
  // Enhanced version of CoCreateInstance that handles failure due to CLSCTX_REMOTESERVER Flag
  //
  static HRESULT CoCreateInstance(REFCLSID rclsid, REFIID riid, LPVOID *ppv)
  {
	// Make sure OLE's initialized
	//
	TInitOle::Init();

	HRESULT hr;

  // Define NO_REMOTE_BINDING if you do not want to try to bind to a remote server
  // (With some setups the remote request is not handled gracefully!?!)
#if !defined(NO_REMOTE_BINDING)
	hr = ::CoCreateInstance(rclsid, 0, CLSCTX_SERVER, riid, ppv);

	// If succeeded, or failed for reasons other than invalid arguments
	//
	if (SUCCEEDED(hr)  || hr != E_INVALIDARG)
      return hr;
#endif

    // Call CoCreateInstance, this time masking off CLSCTX_REMOTE_SERVER
    //
    hr = ::CoCreateInstance(rclsid, 0, CLSCTX_SERVER & ~CLSCTX_REMOTE_SERVER, riid, ppv);
    return hr;
  }

  // Template function to handle Remote Creation
  //
  template <class INTF>
  static HRESULT CreateRemote(LPCWSTR machineName, REFCLSID rclsid, REFIID riid, INTF **ppv)
  {
    // Make sure OLE's initialized
    //
    TInitOle::Init();

    COSERVERINFO serverInfo = {0, const_cast<LPWSTR>(machineName), 0, 0};
    MULTI_QI     mqi        = {&riid, 0, 0};
    HRESULT hr = ::CoCreateInstanceEx(rclsid, 0,
                                      CLSCTX_REMOTE_SERVER,
                                      &serverInfo, 1, &mqi);
    if (SUCCEEDED(hr))
      *ppv = (INTF*)mqi.pItf;
    return hr;
  }
};

// Generic COM Interface wrapper
// Performs proper AddRef/Release when object is copied, assigned to and deleted
//
template <class T,
          const IID *piid = &GUID_NULL> /* NOTE: The IID parameter is for backward-compatibility*/
                                        /*       New code should rely on __uuidof(intf) support */
class TComInterface
{
public:
  TComInterface() : intf(0)
  {}

  // NOTE: The default behaviour of the constructor is to not AddRef the interface
  //       pointer parameter. This is appropriate if the interface was obtained
  //       has already been addRef'ed - as when retrieving a Font property.
  //
  TComInterface(T* p, bool addRef = false)
  {
	if (((intf = p) != 0) && addRef)
	  intf->AddRef();
  }

  #if 0
  TComInterface(int /*ToAllowNull*/) : intf(0)
  {
	/* OLECHECK(ToAllowNull == 0); */
  }
  #endif

  TComInterface(IUnknown* p) : intf(0)
  {
	*this = p;
  }

  TComInterface(IDispatch* p) : intf(0)
  {
	*this = p;
  }

  TComInterface(TVariant var) : intf(0)
  {
    *this = var;
  }

  TComInterface(const TComInterface<T, piid>& src)
  {
    if ((intf = src.intf) != 0)
      intf->AddRef();
  }

  template <class ANOTHERINTF, const IID* ANOTHERIID>
  TComInterface(const TComInterface<ANOTHERINTF, ANOTHERIID>& src) : intf(0)
  {
    _ASSERTE_(/* Need have valid IID to invoke this */GetIID() != GUID_NULL);
    if (src)
    {
      OLECHECK(src->QueryInterface(GetIID(), (LPVOID*)(&intf)));
    }
  }

 ~TComInterface()
  {
    Reset();
  }

  operator T* () const
  {
    return intf;
  }

  T& operator*()
  {
    _ASSERTE_(intf!=0 /* Don't allow *() of smart interface with NULL pointer interface */);
	return *intf;
  }

  // NOTE: You must explicitly Reset() any held interface pointers before invoking
  //       the &operator (presumably to store another interface in the object)
  // (Should we do the Release() automatically and eliminate the _ASSERTE_ check??)
  //
  T** operator & ()
  {
    _ASSERTE_(intf==0 /* Don't allow &() of smart interface with NULL pointer interface */);
    return &intf;
  }

  T* operator->() const
  {
    _ASSERTE_(intf != 0 /* Don't allow ->() of smart interface with NULL pointer interface */);
    return intf;
  }

  T* operator->()
  {
    _ASSERTE_(intf != 0 /*Don't allow ->() of smart interface with NULL pointer interface */);
    return intf;
  }

  void Reset(T* p = 0)
  {
    if (intf)
      intf->Release();
    intf=p;
  }

  void Bind(T* p, bool addRef = false)
  {
    if (p && addRef)
      p->AddRef();
    Reset(p);
  }

  void Unbind()
  {
    Reset(0);
  }

  void AddRef()
  {
    (*this)->AddRef();
  }

  void Release()
  {
    (*this)->Release();
    intf = 0;
  }

  // NOTE: This assignment operator does *NOT* addRef the interface pointer being
  //       assigned to this object.
  //
  TComInterface<T, piid>& operator=(T* p)
  {
    Bind(p);
    return *this;
  }

  #if 0
  TComInterface<T, piid>& operator=(int ToAllowNullAssignment)
  {
    _ASSERTE(ToAllowNullAssignment == 0);
    Reset();
  }
  #endif

  const IID& GetIID() const
  {
    /* If IID was specified we use that, otherwise the interface must support __uuidof(x) via __declspec(uuid(...)) */
    return (*piid != GUID_NULL) ? *piid : __uuidof(T);
  }

  TComInterface<T, piid>& operator=(IUnknown* p);
  TComInterface<T, piid>& operator=(IDispatch* p);
  TComInterface<T, piid>& operator=(TVariant var);

  template <class ANOTHERINTF, const IID* ANOTHERIID>
  TComInterface<T, piid>& operator=(const TComInterface<ANOTHERINTF, ANOTHERIID>& src)
  {
    _ASSERTE_(/* Need have valid IID to invoke this */GetIID() != GUID_NULL);
    Reset();
    if (src)
    {
      OLECHECK(src->QueryInterface(GetIID(), (LPVOID*)(&intf)));
    }
    return *this;
  }

#if defined(SYSTOBJ_H)

  template <class I>
  TComInterface(const DelphiInterface<I>& src)
  {
	if (src) {
	  *this = src;
	}
  }

  template <class I>
  TComInterface<T, piid>& operator=(const DelphiInterface<I>& src)
  {
	_ASSERTE_(/* Need have valid IID to invoke this */GetIID() != GUID_NULL);
	Reset();
	if (src)
	{
	  OLECHECK(src->QueryInterface(GetIID(), (LPVOID*)(&intf)));
	}
	return *this;
  }
#endif

  template <class DISPINTF>
  TComInterface<T, piid>& operator=(const TAutoDriver<DISPINTF>& src)
  {
	_ASSERTE_(/* Need have valid IID to invoke this */GetIID() != GUID_NULL);
	Reset();
	if (src)
	{
	  OLECHECK(src->QueryInterface(GetIID(), (LPVOID*)(&intf)));
	}
	return *this;
  }

  TComInterface<T, piid>& operator=(const TComInterface<T, piid>& src)
  {
	if (src.intf != 0)
	  src.intf->AddRef();
	Reset(src.intf);
	return *this;
  }

  bool      operator ! () const  {   return (intf == 0); }
  operator      bool   () const  {   return (intf != 0); }
  bool      IsBound    () const  {   return !!(*this);   }

  HRESULT   CreateInstance(const CLSID& clsid, IUnknown* pOuter = 0, DWORD dwClsContext = CLSCTX_ALL);
  HRESULT   CreateInstance(LPOLESTR progid, IUnknown* pOuter = 0, DWORD dwClsContext = CLSCTX_ALL);
  HRESULT   ActiveInstance(const CLSID& clsid);
  HRESULT   ActiveInstance(LPOLESTR progId);
  HRESULT   RemoteInstance(LPCWSTR machineName, const CLSID& clsid);


public:
  __property  IID iid = { read = GetIID };

protected:
  T* intf;
};

template <class T, const IID* piid> TComInterface<T, piid>&
TComInterface<T, piid>::operator=(IUnknown* p)
{
  _ASSERTE(/* Need have valid IID to invoke this */GetIID() != GUID_NULL);
  Reset();
  if (p)
  {
	OLECHECK(p->QueryInterface(GetIID(), (LPVOID*)(&intf)));
  }
  return *this;
}

template <class T, const IID* piid> TComInterface<T, piid>&
TComInterface<T, piid>::operator=(IDispatch* p)
{
  _ASSERTE(/* Need have valid IID to invoke this */GetIID() != GUID_NULL);
  Reset();
  if (p)
  {
	OLECHECK(p->QueryInterface(GetIID(), (LPVOID*)(&intf)));
  }
  return *this;
}

template <class T, const IID* piid> TComInterface<T, piid>&
TComInterface<T, piid>::operator=(TVariant var)
{
  _ASSERTE(/* Need have valid IID to invoke this */GetIID() != GUID_NULL);
  IUnknown* punk = var;
  if (punk)
  {
    Reset();
    OLECHECK(punk->QueryInterface(GetIID(), (LPVOID*)(&intf)));
    punk->Release();
  }
  return *this;
}



// Create instance of interface via 'CoCreateInstance' with specified CLSID
//
template <class T, const IID* piid>
HRESULT TComInterface<T, piid>::CreateInstance(const CLSID& clsid, IUnknown* pOuter, DWORD dwClsContext)
{
  Reset();  // Free any interface pointers
  IUnknownPtr punk;
  HRESULT hr = ::CoCreateInstance(clsid, pOuter, dwClsContext, IID_IUnknown, reinterpret_cast<LPVOID*>(&punk));
  if (SUCCEEDED(hr))
  {
    hr = ::OleRun(punk);
    if (SUCCEEDED(hr))
      hr = punk->QueryInterface(GetIID(), reinterpret_cast<LPVOID*>(&intf));
  }
  return hr;
}

// Create instance of interface via 'CoCreateInstance' with specified progid
//
template <class T, const IID* piid>
HRESULT TComInterface<T, piid>::CreateInstance(LPOLESTR progid, IUnknown* pOuter, DWORD dwClsContext)
{
  CLSID clsid;
  HRESULT hr = ::CLSIDFromString(progid, &clsid);
  if (SUCCEEDED(hr))
    return CreateInstance(clsid, pOuter, dwClsContext);
  return hr;
}

// Bind to a running instance of interface via 'GetActiveObject' of specified CLSID
//
template <class T, const IID* piid>
HRESULT TComInterface<T, piid>::ActiveInstance(const CLSID& clsid)
{
  Reset();  // Free any interface pointers
  IUnknownPtr punk;
  HRESULT hr = ::GetActiveObject(clsid, 0, &punk);
  if (SUCCEEDED(hr))
    hr = punk->QueryInterface(GetIID(), reinterpret_cast<LPVOID*>(&intf));
  return hr;
}

// Bind to a running instance of interface via 'GetActiveObject' of specified CLSID
//
template <class T, const IID* piid>
HRESULT TComInterface<T, piid>::ActiveInstance(LPOLESTR progid)
{
  CLSID clsid;
  HRESULT hr = ::CLSIDFromString(progid, &clsid);
  if (SUCCEEDED(hr))
    return ActiveInstance(clsid);
  return hr;
}

// Bind to a remote instance of interface of specified CLSID
//
template <class T, const IID* piid>
HRESULT TComInterface<T, piid>::RemoteInstance(LPCWSTR machineName, const CLSID& rclsid)
{
  return CoClassCreator::CreateRemote(machineName, rclsid, GetIID(), &intf);
}

// Macro used to create typedefs of smart pointers for interfaces.
// Use this macro to create typedefs for standard interfaces not already
// typedefed.
//
#if !defined(_DEF_SMARTPTR)
#define _DEF_SMARTPTR(intf)           class intf; typedef TComInterface<intf>       intf ## Ptr
#define _DEF_SMARTPTR_IID(intf, iid)  class intf; typedef TComInterface<intf, &iid> intf ## Ptr
#endif

// Typedefs for StdVCL interfaces
//
namespace Stdvcl
{class IStrings; class IStringsDisp; class IProvider; class IProviderDisp; class IDataBroker; class IDataBrokerDisp;}
typedef TComInterface<Stdvcl::IStrings>         IStringsPtr;
typedef TComInterface<Stdvcl::IStringsDisp>     IStringsDispPtr;
typedef TComInterface<Stdvcl::IProvider>        IProviderPtr;
typedef TComInterface<Stdvcl::IProviderDisp>    IProviderDispPtr;
typedef TComInterface<Stdvcl::IDataBroker>      IDataBrokerPtr;
typedef TComInterface<Stdvcl::IDataBrokerDisp>  IDataBrokerDispPtr;

extern "C"  const IID IID_IFont;
extern "C"  const IID IID_IPicture;
extern "C"  const IID IID_IFontDisp;
extern "C"  const IID IID_IPictureDisp;
extern "C"  const IID CLSID_StdFont;
extern "C"  const IID CLSID_StdPicture;

#if defined(_INC_COMDEF) || defined(USING_COM_SMARTPTR)

  /*
    If someone wants to use definitions from COMDEF.H and UTILCLS.H, the following
    makes sure that the common typenames do not conflict.
    Define USING_COM_SMARTPTR if you have to include COMDEF.H after UTILCLS.H

    WARNING
    =======
    In order to avoid name clashes (unfortunately none of these types are
    namespaced), we'll rename the types in UTILCLS.H to contain an '_' suffix.

    EXAMPLE
    =======
    The following allows you to use both IDispatchPtr from COMDEF.H and
	IDispatchPtr from UTILCLS.H.

    IDispatchPtr  msDispatch;  _com_ptr version defined in COMDEF.H
    IDispatchPtr_ bDispatch;   TCOMInterface version in UTILCLS.H
  */

  #pragma message "Typenames collision with COMDEF.H (WARNING) "

  #define IDispatchPtr 	  IDispatchPtr_
  #define IUnknownPtr 	  IUnknownPtr_
  #define IFontPtr 	  IFontPtr_
  #define IFontDispPtr 	  IFontDispPtr_
  #define IPicturePtr 	  IPicturePtr_
  #define IPictureDispPtr IPictureDispPtr_
  #define IEnumVARIANTPtr IEnumVARIANTPtr_

#endif

_DEF_SMARTPTR_IID(IUnknown,     IID_IUnknown);
_DEF_SMARTPTR_IID(IDispatch,    IID_IDispatch);
_DEF_SMARTPTR_IID(IFont,        IID_IFont);
_DEF_SMARTPTR_IID(IPicture,     IID_IPicture);
_DEF_SMARTPTR_IID(IFontDisp,    IID_IFontDisp);
_DEF_SMARTPTR_IID(IPictureDisp, IID_IPictureDisp);
_DEF_SMARTPTR_IID(IEnumVARIANT, IID_IEnumVARIANT);

typedef IUnknownPtr  TCOMIUnknown;    /* Backwards compatibility */
typedef IDispatchPtr TCOMIDispatch;   /* Backwards compatibility */

#if defined(_INC_COMDEF) || defined(USING_COM_SMARTPTR)

  #undef IDispatchPtr
  #undef IUnknownPtr
  #undef IFontPtr
  #undef IFontDispPtr
  #undef IPicturePtr
  #undef IPictureDispPtr
  #undef IEnumVARIANTPtr

#endif

// Template used to expose 'factory-like' Create/CreateRemote routines for Clients
//
template <class TOBJ, class INTF, const CLSID* clsid, const IID* iid>
class TCoClassCreatorT : public CoClassCreator
{
public:
  static TOBJ    Create();
  static HRESULT Create(TOBJ& intfObj);
  static HRESULT Create(INTF** ppintf);

  static TOBJ    CreateRemote(LPCWSTR machineName);
  static HRESULT CreateRemote(LPCWSTR machineName, TOBJ& intfObj);
  static HRESULT CreateRemote(LPCWSTR machineName, INTF** ppIntf);
};

template <class TOBJ, class INTF, const CLSID* clsid, const IID* iid>
TOBJ TCoClassCreatorT<TOBJ, INTF, clsid, iid>::Create()
{
  TOBJ intfObj;
  OLECHECK(Create(intfObj));
  return intfObj;
}

template <class TOBJ, class INTF, const CLSID* clsid, const IID* iid>
HRESULT TCoClassCreatorT<TOBJ, INTF, clsid, iid>::Create(TOBJ& intfObj)
{
  return Create(&intfObj);
}

template <class TOBJ, class INTF, const CLSID* clsid, const IID* iid>
HRESULT TCoClassCreatorT<TOBJ, INTF, clsid, iid>::Create(INTF **ppIntf)
{
  return CoCreateInstance(*clsid, *iid, reinterpret_cast<LPVOID*>(ppIntf));
}

template <class TOBJ, class INTF, const CLSID* clsid, const IID* iid>
TOBJ TCoClassCreatorT<TOBJ, INTF, clsid, iid>::CreateRemote(LPCWSTR machineName)
{
  TOBJ intfObj;
  OLECHECK(CreateRemote(machineName, intfObj));
  return intfObj;
}

template <class TOBJ, class INTF, const CLSID* clsid, const IID* iid>
HRESULT TCoClassCreatorT<TOBJ, INTF, clsid, iid>::CreateRemote(LPCWSTR machineName, INTF **ppIntf)
{
  return CoClassCreator::CreateRemote(machineName, *clsid,*iid, ppIntf);
}

template <class TOBJ, class INTF, const CLSID* clsid, const IID* iid>
HRESULT TCoClassCreatorT<TOBJ, INTF, clsid, iid>::CreateRemote(LPCWSTR machineName, TOBJ& intfObj)
{
  return CreateRemote(machineName, &intfObj);
}


// Helper class for cases where VARIANT* or VARIANT& is expected for optional parameters
//
class TNoParam
{
public:
  TNoParam()
  {
    m_Variant.vt = VT_ERROR;
    V_ERROR(&m_Variant) = DISP_E_PARAMNOTFOUND;
  }

  operator VARIANT*  ()         { return &m_Variant;}
  operator VARIANT&  ()         { return m_Variant; }
  operator TVariant* ()         { return &m_Variant;}
  operator TVariant& ()         { return m_Variant; }
  operator TVariantInParam* ()  { return reinterpret_cast<TVariantInParam*>(&m_Variant);}
  operator TVariantInParam& ()  { return *(reinterpret_cast<TVariantInParam*>(&m_Variant));}

private:
  TVariant m_Variant;
};

// Helper class for default LOCALE values
//
class TDefLCID
{
public:
  TDefLCID(LCID lcid = LOCALE_SYSTEM_DEFAULT) : m_Lcid(lcid) {}
  operator LCID () const { return m_Lcid; }

protected:
  LCID  m_Lcid;
};

#if !defined(__AUTOARGS_DEFINED)
#include <autoargs.h>
#endif

// Enumeration describing DISPATCH type
//
enum DispatchFlag
{
  dfMethod    = DISPATCH_METHOD,
  dfPropGet   = DISPATCH_PROPERTYGET,
  dfPropPut   = DISPATCH_PROPERTYPUT,
  dfPropPutRef= DISPATCH_PROPERTYPUTREF
};

// Sets the value in the returnVariant to the retVal variable if SUCCEEDED(hr)
// Used by DispInterface Code Generated by TLIBIMP
//
template <class T>
HRESULT OutRetValSetterPtr(T* retVal, TAutoArgsBase& args, HRESULT hr)
{
  if (SUCCEEDED(hr))
    *retVal = T(args.GetRetVariant());
  return hr;
}

// Sets the value in the returnVariant to the retVal variable if SUCCEEDED(hr)
// Used by DispInterface Code Generated by TLIBIMP
template <class T>
HRESULT OutRetValSetterRef(T& retVal, TAutoArgsBase& args, HRESULT hr)
{
  if (SUCCEEDED(hr))
    retVal = T(args.GetRetVariant());
  return hr;
}


// NOTE: VCL classes currently require the following option.
///      Update these if the default for VCL classes change.
//
#pragma option push -b- -a4

// (Dummy) Component Fake class
// (This class and the TDispatchDelegate template allows the TEventsDispatcher class to be used for
//  generic [non-VCL, Component, Form-based] event dispatching, as well as be the base class of a
//  Form-based component. The difficulties stem from the [f]rigid rules of VCL classes: no multiple
//  inheritance... not even interfaces (Delphi allow these at least but the C++ side is more Delphiesque
//  than Delphi). In order not to duplicate code in two templates, we'll use some dummy classes that
//  remove IDispatch as a base class [since it can't be a base if TComponent is a base class] and allows
//  for a TComponent-derived based class).
//
class TFakeComponentBase
{
public:
  TFakeComponentBase() {}
  TFakeComponentBase(TFakeComponentBase*) {}
};

// Template to delegate implementation of IDispatch to T
// (To work around not allowing MI in VCL class hierarchy - Compiler should allow interfaces but doesn't - BUG??)
//
template <class T>
class TDispatchDelegate : public IDispatch
{
  T&      m_DispImpl;
public:
  TDispatchDelegate(T& impl) : m_DispImpl(impl) {}

  // IUnknown
  HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid, void **ppvObject) { return m_DispImpl.QueryInterface(iid, ppvObject); }
  ULONG   STDMETHODCALLTYPE AddRef()                                     { return m_DispImpl.AddRef();  }
  ULONG   STDMETHODCALLTYPE Release()                                    { return m_DispImpl.Release(); }
  // IDispatch
  // IDispatch
  HRESULT STDMETHODCALLTYPE GetTypeInfoCount(UINT* pctInfo)
  {
    *pctInfo = 0;
    return S_OK;
  }
  HRESULT STDMETHODCALLTYPE GetTypeInfo(UINT, LCID, ITypeInfo** ppTypeInfo)
  {
    *ppTypeInfo = 0;
    return E_NOTIMPL;
  }
  HRESULT STDMETHODCALLTYPE GetIDsOfNames(REFIID, LPOLESTR*, UINT, LCID, DISPID*)
  {
    return E_NOTIMPL;
  }
  HRESULT STDMETHODCALLTYPE Invoke(DISPID dispid, REFIID iid, LCID lcid, WORD wFlags, DISPPARAMS *pDispParams,
                                   VARIANT *pVarResult, EXCEPINFO *pExcepInfo, UINT *puArgError)
  {
    return m_DispImpl.Invoke(dispid, iid, lcid, wFlags, pDispParams, pVarResult, pExcepInfo, puArgError);
  }
};


// TEventDispatcher<>
// ==================
//
// TEventDispatcher<> offer a simple sink implementation: i.e. an implementation of IDispatch that servers
// can call upon to fire events. The template also exposes routines to allow one to easy connect to and
// disconnect the sink from a Server.
//
template <class T, const IID *pEVENTSIID, class BASE = TFakeComponentBase>
class TEventDispatcher : public BASE
{
  typedef TEventDispatcher<T, pEVENTSIID, BASE> ThisClass;

  int                           m_Ref;          // Ref count holder
  DWORD                         m_EventCookie;  // Event Advise/Unadvise cookie
  TDispatchDelegate<ThisClass>  m_Dispatch;     // IDispatch implementation

protected:
  // To be overriden in derived class to dispatch events
  virtual HRESULT InvokeEvent(DISPID id, TVariant* params = 0) = 0;

  // COnnect Event IDispatch to Server
  HRESULT ConnectEvents(IUnknown *server) {
    return COMHlpr_ConnectEvents(*pEVENTSIID, server, static_cast<IUnknown*>(&m_Dispatch), m_EventCookie);
  }
  HRESULT DisconnectEvents(IUnknown *server) {
    return COMHlpr_DisconnectEvents(*pEVENTSIID, server, m_EventCookie);
  }

public:
  TEventDispatcher() : m_Ref(0), m_EventCookie(0), m_Dispatch(*this)
  {}

  TEventDispatcher(BASE* owner) : BASE(owner), m_Ref(0), m_EventCookie(0), m_Dispatch(*this)
  {}

  // IUnknown
  HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid, void **ppvObject);
  ULONG   STDMETHODCALLTYPE AddRef()    { return ++m_Ref; }
  ULONG   STDMETHODCALLTYPE Release()   { return --m_Ref; }

  HRESULT STDMETHODCALLTYPE Invoke(DISPID dispid, REFIID iid, LCID lcid, WORD wFlags, DISPPARAMS *pDispParams,
                                   VARIANT *pVarResult, EXCEPINFO *pExcepInfo, UINT *puArgError);
};

// TEventsDispatcher::IUnknown::QueryInterface
//
template <class T, const IID *pEVENTSIID, class BASE> HRESULT STDMETHODCALLTYPE
TEventDispatcher<T, pEVENTSIID, BASE>::QueryInterface(REFIID iid, void **ppvObject)
{
  *ppvObject = 0;
  if ((iid == IID_IDispatch) || (iid == *pEVENTSIID))
  {
    /*static_cast<T*>*/(this)->AddRef();
    *ppvObject = static_cast<IDispatch*>(&m_Dispatch);
  }
  else if (iid == IID_IUnknown)
  {
    /*static_cast<T*>*/(this)->AddRef();
    *ppvObject = static_cast<IUnknown*>(&m_Dispatch);
  }
  else
    return E_NOINTERFACE;
  return S_OK;
}

// TEventsDispatcher::IDispatch::Invoke
//
template <class T, const IID *pEVENTSIID, class BASE> HRESULT STDMETHODCALLTYPE
TEventDispatcher<T, pEVENTSIID, BASE>::Invoke(DISPID dispid, REFIID /*iid*/, LCID /*lcid*/,
                                              WORD /*wFlags*/, DISPPARAMS* pDispParams,
                                              VARIANT* /*pVarResult*/, EXCEPINFO* /*pExcepInfo*/,
                                              UINT* /*puArgError*/)
{
  TAPtr<TVariant> pParamArray;
  TVariant *pArrayPtr = 0;
  if (pDispParams->cArgs)
  {
    int count = pDispParams->cArgs;
    pParamArray = new TVariant[count];
    // NOTE: row vs. column major!
    for (UINT i=0; i<pDispParams->cArgs; i++)
      pParamArray[count-(i+1)] = pDispParams->rgvarg[i];
    pArrayPtr = pParamArray;
  }
  return InvokeEvent(dispid, pArrayPtr);
};


// If you want to access the following template you must make sure that CLASSES.HPP
// has been included before UTILCLS.H is included.
//
#if defined(ClassesHPP)
#include <oleserver.hpp>


// Declare a macro so we may check if the headers were properly included
//
#define __BASE_OF_COMOBJECT_AS_COMPONENT_DEFINED

#if !defined(OleserverHPP)
// Server Component connection type
//
enum TConnectKind
{
  ckRunningOrNew,       // Attach to a running instance or create new one
  ckNewInstance,        // Create a new instance of the server
  ckRunningInstance,    // Attach to a running instance of the server
  ckRemote,             // Bind to a remote instance of the server
  ckAttachToInterface   // Don't bind to server - interface will be provided programmatically
};
#endif

#if defined(DSTRING_H)
// TImportCOMObject<>: Support class utilized by C++Builder's
// Import TypeLibrary|Install feature. The code generated by
// C++Builder uses TImportCOMObject to expose COM servers as
// IDE components.
//
template <class T,                            /* Implementation class (typically most-derived)      */
          class DEFAULTINTF,                  /* IDefaultInterfaceNamePtr: _ApplicationPtr for ex.  */
          const CLSID* pDEFAULTCLSID,         /* CLSID of CoClass: CLSID_Application for example    */
          const IID*   pEVENTSIID=&GUID_NULL> /* DIID_IxxxEvents, __uuidof(IDefaultInterfaceEvents) */
class PACKAGE TImportedCOMObject : public TEventDispatcher<T, pEVENTSIID, Classes::TComponent>
{
  typedef       TEventDispatcher<T, pEVENTSIID, Classes::TComponent> TBaseClass;

  DEFAULTINTF   m_DefaultInterface;
  bool          FAutoConnect;
  AnsiString    FRemoteMachineName;
  ::TConnectKind  FConnectKind;

public:
  // Component's Constructor
  //
  __fastcall TImportedCOMObject(TComponent* owner) : TBaseClass(owner)
  {
    FConnectKind = ckRunningOrNew;
    FAutoConnect = false;
  }

  // Override 'Loaded' to support 'AutoConnect'
  //
  virtual void __fastcall Loaded()
  {
    TBaseClass::Loaded();
    if (AutoConnect)
      Connect();
  }
  // Override 'BeforeDestruction' to disconnect
  virtual void __fastcall BeforeDestruction()
  {
    Disconnect(); // Handles case where we're *NOT* connected
    TBaseClass::BeforeDestruction();
  }


  // Connect/Disconnect Component to COM Object & Return default underlying Interface
  //
  HRESULT      Connect();
  HRESULT      Disconnect();
  HRESULT      ConnectTo(DEFAULTINTF defaultIntf);
  bool         IsConnected() { return !!m_DefaultInterface; }

  virtual void ShutDown() {/* For derived classes to override */}

  // NOTE: GetDefaultInterface() will 'Connect' if we're not connected.
  //       The 'DefaultInterface' property does *NOT* attempt to connect.
  DEFAULTINTF  GetDefaultInterface();
  __property DEFAULTINTF  DefaultInterface = { read = m_DefaultInterface };

  // Accessors for AutoConnect
  void __fastcall SetAutoConnect(bool autoConnect) { FAutoConnect = autoConnect; }
  bool __fastcall GetAutoConnect()                 { return (ConnectKind==ckAttachToInterface) ? false : FAutoConnect; }

  // Accessors for ConnectKind
  ::TConnectKind __fastcall  GetConnectKind()               { return RemoteMachineName.IsEmpty() ? FConnectKind : ckRemote; }
  void __fastcall          setConnectKind(::TConnectKind ck){ FConnectKind = ck; }

  // Standard properties of imported Server Components
  __property bool         AutoConnect      = { read = GetAutoConnect, write = SetAutoConnect };
  __property ::TConnectKind ConnectKind      = { read = GetConnectKind, write = setConnectKind };
  __property AnsiString   RemoteMachineName= { read = FRemoteMachineName, write = FRemoteMachineName };
};

//
//
template <class T,
          class DEFAULTINTF,
          const CLSID* pDEFAULTCLSID,
          const IID*   pEVENTSIID> HRESULT
TImportedCOMObject<T, DEFAULTINTF, pDEFAULTCLSID, pEVENTSIID>::Connect()
{
  HRESULT hr = 0;
  if (!m_DefaultInterface) {
    switch (ConnectKind)
    {
      case ckRunningInstance:
      case ckRunningOrNew:
            hr = m_DefaultInterface.ActiveInstance(*pDEFAULTCLSID);
            if (SUCCEEDED(hr))
              break;
            if (ConnectKind == ckRunningInstance) {
              // THROW-ISSY-FIT
              break;
            }
            // NOTE: Here fall through to new instance creation attempt

      case ckNewInstance:
            hr = m_DefaultInterface.CreateInstance(*pDEFAULTCLSID);
            break;

      case ckRemote:
            hr = m_DefaultInterface.RemoteInstance(WideString(RemoteMachineName),
                                                   *pDEFAULTCLSID);
            break;
      default:
            hr = E_FAIL;
            break;
    }
    // Try to connect events, if we have an events interface
    if (SUCCEEDED(hr) && (*pEVENTSIID != GUID_NULL)/*GUID_NULL specifies no events*/)
      hr = ConnectEvents(m_DefaultInterface);
  }
  return hr;
}

//
//
template <class T,
          class DEFAULTINTF,
          const CLSID* pDEFAULTCLSID,
          const IID*   pEVENTSIID> HRESULT
TImportedCOMObject<T, DEFAULTINTF, pDEFAULTCLSID, pEVENTSIID>::Disconnect()
{
  HRESULT hr = S_OK;
  if (m_DefaultInterface) {
    ShutDown(); // Allow derived classes to perform any cleanup
    if (*pEVENTSIID != GUID_NULL)
      hr = DisconnectEvents(m_DefaultInterface);
    m_DefaultInterface.Reset();
  }
  return hr;
}


//
//
template <class T,
          class DEFAULTINTF,
          const CLSID* pDEFAULTCLSID,
          const IID*   pEVENTSIID> HRESULT
TImportedCOMObject<T, DEFAULTINTF, pDEFAULTCLSID, pEVENTSIID>::ConnectTo(DEFAULTINTF defaultIntf)
{
  HRESULT hr = DisConnect();
  if (SUCCEEDED(hr))
  {
    if (defaultIntf)
    {
      m_DefaultInterface = defaultIntf;
      if (*pEVENTSIID != &GUID_NULL)
        hr = ConnectEvents(m_DefaultInterface);
    }
  }
  return hr;
}


//
//
template <class T,
          class DEFAULTINTF,
          const CLSID* pDEFAULTCLSID,
          const IID*   pEVENTSIID=&GUID_NULL> DEFAULTINTF
TImportedCOMObject<T, DEFAULTINTF, pDEFAULTCLSID, pEVENTSIID>::GetDefaultInterface()
{
  // We auto-connect is someone asks for the default interface
  if (!m_DefaultInterface)
    OLECHECK(Connect());
  // Return underlying interface
  return m_DefaultInterface;
}

#endif // DString_H

#endif  // ClassesHPP


#pragma option pop

// Base class of smart interface wrappers - provides an optional parameter
//
template <class INTF>
class TComInterfaceBase
{
public:
  static TNoParam     OptParam;
  static LCID         lcid;
  static VARIANT_BOOL Variant_False;
  static VARIANT_BOOL Variant_True;
};

// Static/shared instance of 'Optional parameter' and 'lcid' settings
//
template <class T>
TNoParam TComInterfaceBase<T>::OptParam;
template <class T>
LCID     TComInterfaceBase<T>::lcid = LOCALE_SYSTEM_DEFAULT;
template <class T>
VARIANT_BOOL TComInterfaceBase<T>::Variant_False = VARIANT_FALSE;
template <class T>
VARIANT_BOOL TComInterfaceBase<T>::Variant_True  = VARIANT_TRUE;

// Base class of AutoDrivers - provides an optional parameter
//
template <class DISPINTF>
class TAutoDriverBase
{
public:
  static TNoParam OptParam;
  static VARIANT_BOOL Variant_False;
  static VARIANT_BOOL Variant_True;
  static TInitOle     InitOle;
};

// Static/shared instance of 'Optional Parameter'
//
template <class T>
TNoParam TAutoDriverBase<T>::OptParam;
template <class T>
VARIANT_BOOL TAutoDriverBase<T>::Variant_False = VARIANT_FALSE;
template <class T>
VARIANT_BOOL TAutoDriverBase<T>::Variant_True  = VARIANT_TRUE;
template <class T>
TInitOle TAutoDriverBase<T>::InitOle;

// TAutoDriver - DispInterface Automation Proxy Driver
//
template <class DISPINTF>
class TAutoDriver : public TAutoDriverBase<IDispatch>
{
public:
  TAutoDriver(LCID lcid = LOCALE_SYSTEM_DEFAULT);
  TAutoDriver(const TAutoDriver<DISPINTF>  &src);
  TAutoDriver(const DISPINTF* src);
 ~TAutoDriver();

  TAutoDriver<DISPINTF>& operator =(const TAutoDriver<DISPINTF>& src)
  {
    Unbind();
    if (src) {
      Bind((DISPINTF*)(src), true/*AddRef()*/);
    }
    return *this;
  }
  
  // Assignment of interface to object implies Bind to interface
  //
  TAutoDriver<DISPINTF>& operator =(DISPINTF *pintf)
  {
    Bind(pintf);
    return *this;
  }
  
#if defined(SYSTOBJ_H)
  template <class I>
  TAutoDriver<DISPINTF>& operator=(const DelphiInterface<I>& src)
  {
    DISPINTF *intf = 0;
    if (src) {
     HRESULT hr = src->QueryInterface(__uuidof(DISPINTF), (LPVOID*)(&intf));
     if (SUCCEEDED(hr))
       Bind(intf, false/*Don't AddRef()*/);
    }
    return *this;
  }
#endif

  // Bind via various mechanisms & Unbind
  // NOTE: Does *NOT* AddRef interface by default
  //
  void    Bind(DISPINTF *pintf, bool addRef = false);
  HRESULT Bind(LPUNKNOWN punk);
  HRESULT Bind(const GUID& guid);
  HRESULT Bind(LPCWSTR progid);

  // Bind to running copy of Server
  //
  HRESULT BindToActive(const GUID& guid);
  HRESULT BindToActive(LPCWSTR progid);

  // Bind to remote server
  //
  HRESULT BindToRemote(LPCWSTR machineName, const CLSID& clsid);
  HRESULT BindToRemote(LPCWSTR machineName, LPCWSTR progid);

  // Unbind from DispInterface
  //
  void    Unbind(bool release = true);
  void    Reset() { Unbind(true); }


  // Return Dispatch Interface
  //
  operator DISPINTF*()  const;

  // Bound or not?
  //
  bool     IsBound()    const;
  bool operator ! ()    const { return m_Dispatch == 0; }
  operator bool   ()    const { return m_Dispatch != 0; }

  // Allows access to interface being held
  // NOTE: Useful when dealing with dual interfaces
  //       Using '->' yields Vtable call while '.' yields Invoke call
  DISPINTF* operator -> ()
  {
    _ASSERTE_(m_Dispatch != 0 /* Must be bound to interface before using -> operator */);
    return m_Dispatch;
  }

  DISPINTF* operator-> () const
  {
    _ASSERTE_(m_Dispatch != 0 /* Must be bound to interface before using -> operator */);
    return m_Dispatch;
  }

  // Return address of interface
  //
  DISPINTF** operator & ()
  {
    // Can take address (to presumably stuff new interface pointer) only if
    // not currently Bound;
    _ASSERTE_(m_Dispatch==0 /* Don't allow &() of non-Bound TAutoDriver<> */);
    return &m_Dispatch;
  }

  // Wrappers of IDispatch methods
  //
  HRESULT GetIDsOfNames(LPCWSTR name, DISPID &id);
  HRESULT Invoke(DispatchFlag dFlags, LPCWSTR name, TAutoArgsBase* args, bool hasRetVal = true);
  HRESULT Invoke(DispatchFlag dFlags, DISPID dispId, TAutoArgsBase* args, bool hasRetVal = true);

  // Access to LCID settings
  //
  LCID get_lcid() const { return m_lcid;}
  void set_lcid(LCID l) { m_lcid = l;   }

  // Access to EXCEPINFO
  //
  EXCEPINFO const & get_excepinfo() const { return m_ExcepInfo; }

  // Properties
  //
  __property LCID lcid = { read = get_lcid, write = set_lcid };
  __property EXCEPINFO excepinfo = { read = get_excepinfo    };

  // Procedures with/without parameters
  //
  HRESULT OleProcedure(DISPID dispid, TAutoArgsBase& args)
  {
    return Invoke(dfMethod, dispid, &args, false);
  }
  HRESULT OleProcedure(DISPID dispid)
  {
    return Invoke(dfMethod, dispid, 0, false);
  }

  // FUnctions with/without parameters
  HRESULT OleFunction(DISPID dispid, TAutoArgsBase& args)
  {
    return Invoke(dfMethod, dispid, &args, true);
  }
  HRESULT OleFunction(DISPID dispid)
  {
    return Invoke(dfMethod, dispid, 0, false);
  }

  // Property put (always has parameters)
  HRESULT OlePropertyPut(DISPID dispid, TAutoArgsBase& args)
  {
    return Invoke(dfPropPut, dispid, &args, false);
  }

  // Property get (always has parameters, even if just TAutoArgs<0>)
  HRESULT OlePropertyGet(DISPID dispid, TAutoArgsBase& args)
  {
    return Invoke(dfPropGet, dispid, &args, true);
  }

  // Property get that returns VARIANT
  VARIANTOBJ OlePropertyGet(DISPID dispid);

protected:

  typedef TDispId<DISPINTF> _TDispID;

  // Functions hold and let go of interface (no AddRef or Releases)
  // Used by Events interface wrappers
  //
  void        Attach(DISPINTF *pintf) { m_Dispatch = pintf;}
  void        Detach()                { m_Dispatch = 0;    }

  DISPINTF   *m_Dispatch;           // Disp Interface Pointer
  LCID        m_lcid;               // Locale for DispId lookup & Invoke
  EXCEPINFO   m_ExcepInfo;          // Exception Structure
  UINT        m_ErrArg;             // Index of erroneous argument
};


// TDispIdBase - Base class used by TDispId; allows us to have only one copy of the
//               flag governing whether DISPID should be looked up
template <class T>
class TDispIdBase
{
public:
  static  bool m_AlwaysGetDispid;
};

// This flag triggers a lookup even if the object was pass a valid (non -1) dispid!
// (Be careful if you enable this: Source interfaces do not typically expect a GetIDsofNames call)
//
template <class T>
bool TDispIdBase<T>::m_AlwaysGetDispid = false;

// TDispId - Class used to retrieve and cache a DISPID
//
template<class DISPINTF>
class TDispId : public TDispIdBase<DISPINTF>
{
public:
  TDispId(TAutoDriver<DISPINTF>& dispatch, LPCWSTR pName, DISPID id= DISPID_UNKNOWN) : m_DispId(id),
                                                                                       m_HResult(S_OK)
  {
    if (id == DISPID_UNKNOWN || m_AlwaysGetDispid)
      m_HResult = GetID(dispatch, pName);
  }

  TDispId(DISPID id) : m_DispId(id), m_HResult(S_OK)
  {}

  HRESULT GetID(TAutoDriver<DISPINTF>& dispatch, LPCWSTR pName)
  {
    return dispatch.GetIDsOfNames(pName, m_DispId);
  }

  operator DISPID() const
  {
    return  m_DispId;
  }

  HRESULT GetResult() const
  {
    return m_HResult;
  }


protected:
  DISPID    m_DispId;
  HRESULT   m_HResult;
};


// Ctr & Dtr of Automation Driver class
//
template <class DISPINTF>
TAutoDriver<DISPINTF>::TAutoDriver(LCID lcid) : m_Dispatch(0), m_lcid(lcid)
{
  // Clear out ErrArg and ExcepInfo.
  m_ErrArg=0;
  ::ZeroMemory(&m_ExcepInfo, sizeof(m_ExcepInfo));
}

//

template <class DISPINTF>
TAutoDriver<DISPINTF>::TAutoDriver(const TAutoDriver<DISPINTF>  &src)
{
  // NOTE: We do not copy the Exception or ErrArg objects
  //       We simply clear them out
  m_ErrArg = 0;
  ::ZeroMemory(&m_ExcepInfo, sizeof(m_ExcepInfo));

  // Copy Interface and AddRefCount
  m_Dispatch = src.m_Dispatch;
  if (m_Dispatch)
    m_Dispatch->AddRef();

  // Copy Locale
  m_lcid = src.m_lcid;
}

template <class DISPINTF>
TAutoDriver<DISPINTF>::TAutoDriver(const DISPINTF* src)
{
  // NOTE: We do not copy the Exception or ErrArg objects
  //       We simply clear them out
  m_ErrArg = 0;
  ::ZeroMemory(&m_ExcepInfo, sizeof(m_ExcepInfo));

  // Copy Interface and AddRefCount
  m_Dispatch = src;
  if (m_Dispatch)
    m_Dispatch->AddRef();

  m_lcid = LOCALE_SYSTEM_DEFAULT;
}

template <class DISPINTF>
TAutoDriver<DISPINTF>::~TAutoDriver()
{
  Unbind();
}

// Bind via Dispatch Interface
// NOTE: Does *NOT* AddRef interface
//
template <class DISPINTF> void
TAutoDriver<DISPINTF>::Bind(DISPINTF *pintf, bool addRef)
{
  if (pintf && addRef)
    pintf->AddRef();
  Unbind();
  m_Dispatch = pintf;
}

// Bind via IUnknown
//
template <class DISPINTF> HRESULT
TAutoDriver<DISPINTF>::Bind(LPUNKNOWN punk)
{
  _ASSERTE(punk /* Must bind to non-NULL interface pointer */);
  HRESULT hr = E_POINTER;
  if (punk)
  { 
    DISPINTF *disp;
    hr = punk->QueryInterface(__uuidof(DISPINTF), (LPVOID*)&disp);
    if (SUCCEEDED(hr))
      Bind(disp, false /* Don't AddRef */);
  }
  return hr;
}

// Bind via GUID
//
template <class DISPINTF> HRESULT
TAutoDriver<DISPINTF>::Bind(const GUID& clsid)
{
  LPUNKNOWN punk = 0;
  HRESULT hr = CoClassCreator::CoCreateInstance(clsid, IID_IUnknown, (LPVOID*)&punk);
  if (SUCCEEDED(hr))
  {
    // We should have a valid interface pointer
    //
    _ASSERTE(punk /* Must have valid IUnknown pointer */);

    // Run Object - just in case
    //
    hr = ::OleRun(punk);

    // Bind to running IUnknown
    //
    if (SUCCEEDED(hr))
      hr = Bind(punk);

    // Release IUnknown
    //
    punk->Release();
  }
  return hr;
}

// Bind via ProgId
//
template <class DISPINTF> HRESULT
TAutoDriver<DISPINTF>::Bind(LPCWSTR progid)
{
  GUID clsid;
  HRESULT hr = ::CLSIDFromProgID(progid, &clsid);
  if (SUCCEEDED(hr))
    return Bind(clsid);
  return hr;
}

// Bind to running copy of Object of this CLSID
//
template <class DISPINTF> HRESULT
TAutoDriver<DISPINTF>::BindToActive(const GUID& guid)
{
  LPUNKNOWN punk = 0;
  HRESULT hr = ::GetActiveObject(guid, 0, &punk);
  if (SUCCEEDED(hr))
    return Bind(punk);
  return hr;
}

// Bind to running copy of object with the specified progId
//
template <class DISPINTF> HRESULT
TAutoDriver<DISPINTF>::BindToActive(LPCWSTR progid)
{
  CLSID clsid;
  HRESULT hr = ::CLSIDFromProgID(progid, &clsid);
  if (SUCCEEDED(hr))
    return BindToActive(clsid);
  return hr;
}

// Bind to remote server on specified machine
//
template <class DISPINTF> HRESULT
TAutoDriver<DISPINTF>::BindToRemote(LPCWSTR machineName, const CLSID& clsid)
{
  DISPINTF *pIntf = 0;
  HRESULT hr = CoClassCreator::CreateRemote(machineName, clsid, __uuidof(DISPINTF), &pIntf);
  if (SUCCEEDED(hr))
    Bind(pIntf, false /* Don't Addref() - CreateRemote returns refcounted interface */ );
  return hr;
}

// Bind to remote server on specified machine
//
template <class DISPINTF> HRESULT
TAutoDriver<DISPINTF>::BindToRemote(LPCWSTR machineName, LPCWSTR progid)
{
  CLSID clsid;
  HRESULT hr = ::CLSIDFromProgID(progid, &clsid);
  if (SUCCEEDED(hr))
    return BindToRemote(machineName, clsid);
  return hr;
}

// Release Dispatch Interface
//
template <class DISPINTF> void
TAutoDriver<DISPINTF>::Unbind(bool release)
{
  if (release && m_Dispatch)
    m_Dispatch->Release();
  m_Dispatch = 0;
}

// Return Dispatch Interface
// NOTE: Does *NOT* AddRef()
//
template <class DISPINTF>
TAutoDriver<DISPINTF>::operator DISPINTF* () const
{
  return m_Dispatch;
}

// Returns Boolean indicating whether we're currently bound to the Server
//
template <class DISPINTF> bool
TAutoDriver<DISPINTF>::IsBound() const
{
  return m_Dispatch != 0;
}

// Encapsulation of IDispatch->GetIDsOfNames
//
template <class DISPINTF> HRESULT
TAutoDriver<DISPINTF>::GetIDsOfNames(LPCWSTR name, DISPID &id)
{
  _ASSERTE(name /* Need non-NULL name to perform DISPID lookup */);
  _ASSERTE(IsBound() /* Must be bound to perform DISPID lookup */);
  return m_Dispatch->GetIDsOfNames(IID_NULL, (LPWSTR*)(&name), 1, m_lcid, &id);
}

// Invoke specified 'name'
//
template <class DISPINTF> HRESULT
TAutoDriver<DISPINTF>::Invoke(DispatchFlag dFlags, LPCWSTR name, TAutoArgsBase* args, bool hasRetVal)
{
  DISPID dispid;
  HRESULT hr = GetIDsOfNames(name, dispid);
  if (SUCCEEDED(hr))
    hr = Invoke(dFlags, dispid, args);
  return hr;
}

// Invoke specified 'DispId'
//
template <class DISPINTF> HRESULT
TAutoDriver<DISPINTF>::Invoke(DispatchFlag dFlags, DISPID dispid, TAutoArgsBase* args, bool hasRetVal)
{
  _ASSERTE(IsBound() /* Must be bound to perform Invoke() */);

  VARIANT* retVal = 0;

  // Having return value implies an Args array (even if it contains only one
  // variant for the return value).
  //
  _ASSERTE((hasRetVal==false && args==0) ||
           (hasRetVal==false && args!=0) ||
           (hasRetVal==true  && args!=0));

  // Setup return VARIANT
  // NOTE: PROPERTYPUTs do not return a result
  //
  if (!(dFlags & (dfPropPut|dfPropPutRef)) && hasRetVal)
    retVal = (VARIANT*)(args->GetRetVal());

  // Special DispId for Property Puts
  //
  static DISPID DispIdPropertyPut = DISPID_PROPERTYPUT;

  // Setup DISPATCH parameters
  //
  DISPPARAMS params;
  ::ZeroMemory(&params, sizeof(params));

  // Set parameters (Note: PropPut[Ref] expected to have Count)
  if (args && args->GetCount())
  {
    params.cArgs = args->GetCount();
    params.rgvarg= (VARIANT*)(args->GetArgs());

    // Handle PROPERTYPUT
    // NOTE: Assumes no named-arguments params have been setup
    //
    if (dFlags & (dfPropPut|dfPropPutRef))
    {
      params.cNamedArgs = 1;
      params.rgdispidNamedArgs = &DispIdPropertyPut;
    }
  }

  // Reset Error Information
  m_ErrArg = 0;
  ::ZeroMemory(&m_ExcepInfo, sizeof(m_ExcepInfo));

  // Invoke
  HRESULT hr = m_Dispatch->Invoke(dispid, IID_NULL, m_lcid, WORD(dFlags), &params,
                                  retVal, &m_ExcepInfo, &m_ErrArg);

  // Check for deferred EXCEPTION fill-in
  if (hr == DISP_E_EXCEPTION)
    if (m_ExcepInfo.pfnDeferredFillIn)
      (*(m_ExcepInfo.pfnDeferredFillIn))(&m_ExcepInfo);

  // Turn on '__CHECKHR_ON_INVOKE' when you're debugging calls using the DISP wrappers
  //
#if defined(__CHECKHR_ON_INVOKE)
  OLECHECK(hr);
#endif

  // Output a little trace
  OLETRACE(_T("Inv(%d) %s, 0x%lX, retVT(0x%X), ErrArg(%d)\n"),
           dispid, SUCCEEDED(hr) ? _T("OK") : _T("FL"), LONG(hr),
           retVal ? retVal->vt : VT_NULL, m_ErrArg);

  // Return result
  return hr;
}

// Property Get that returns a Variant (takes no parameters)
//
template <class DISPINTF> VARIANTOBJ
TAutoDriver<DISPINTF>::OlePropertyGet(DISPID dispid)
{
  TAutoArgs<0> args;
  OlePropertyGet(dispid, args);
  return args.GetRetVariant();
}

// Use for Dispinterfaces (gives them Invoke wrappers).
//
template <class T>
class TDispWrapper : public T
{
  typedef TDispId<T> _TDispID;
public:
  HRESULT __fastcall OleProcedure(DISPID dispid, TAutoArgsBase& args);
  HRESULT __fastcall OleProcedure(DISPID dispid);
  HRESULT __fastcall OleFunction(DISPID dispid, TAutoArgsBase& args);
  HRESULT __fastcall OleFunction(DISPID dispid);
  HRESULT __fastcall OlePropertyPut(DISPID dispid, TAutoArgsBase& args);
  HRESULT __fastcall OlePropertyGet(DISPID dispid, TAutoArgsBase& args);
};

template <class T> HRESULT __fastcall
TDispWrapper<T>::OleProcedure(DISPID dispid, TAutoArgsBase& args)
{
  TAutoDriver<T> driver;
  driver.Bind(this, true);
  return driver.OleProcedure(dispid, args);
}
template <class T> HRESULT __fastcall
TDispWrapper<T>::OleProcedure(DISPID dispid)
{
  TAutoDriver<T> driver;
  driver.Bind(this, true);
  return driver.OleProcedure(dispid);
}
template <class T> HRESULT __fastcall
TDispWrapper<T>::OleFunction(DISPID dispid, TAutoArgsBase& args)
{
  TAutoDriver<T> driver;
  driver.Bind(this, true);
  return driver.OleFunction(dispid, args);
}
template <class T> HRESULT __fastcall
TDispWrapper<T>::OleFunction(DISPID dispid)
{
  TAutoDriver<T> driver;
  driver.Bind(this, true);
  return driver.OleFunction(dispid);
}
template <class T> HRESULT __fastcall
TDispWrapper<T>::OlePropertyPut(DISPID dispid, TAutoArgsBase& args)
{
  TAutoDriver<T> driver;
  driver.Bind(this, true);
  return driver.OlePropertyPut(dispid, args);
}
template <class T> HRESULT __fastcall
TDispWrapper<T>::OlePropertyGet(DISPID dispid, TAutoArgsBase& args)
{
  TAutoDriver<T> driver;
  driver.Bind(this, true);
  return driver.OlePropertyGet(dispid, args);
}

#pragma obsolete TVariantInParam
#endif  __UTILCLS_H
